/*
 * Thermal_system_full.c
 *
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 *
 * Code generation for model "Thermal_system_full".
 *
 * Model version              : 1.3
 * Simulink Coder version : 9.4 (R2020b) 29-Jul-2020
 * C source code generated on : Fri Feb 21 15:05:36 2025
 *
 * Target selection: dsrt.tlc
 * Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: Custom Processor->Custom
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Thermal_system_full_dsrtvdf.h"
#include "Thermal_system_full.h"
#include "Thermal_system_full_private.h"

/* Block signals (default storage) */
B_Thermal_system_full_T Thermal_system_full_B;

/* Continuous states */
X_Thermal_system_full_T Thermal_system_full_X;

/* Block states (default storage) */
DW_Thermal_system_full_T Thermal_system_full_DW;

/* Mass Matrices */
MassMatrix_Thermal_system_ful_T Thermal_system_full_MassMatrix;

/* Real-time model */
static RT_MODEL_Thermal_system_full_T Thermal_system_full_M_;
RT_MODEL_Thermal_system_full_T *const Thermal_system_full_M =
  &Thermal_system_full_M_;

/* ForcingFunction for root system: '<Root>' */
void Thermal_system_full_forcingfunction(void)
{
  NeslSimulationData *simulationData;
  NeslSimulator *simulator;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  XDot_Thermal_system_full_T *_rtXdot;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  int_T tmp_1[25];
  int_T is;
  boolean_T tmp;
  _rtXdot = ((XDot_Thermal_system_full_T *) Thermal_system_full_M->derivs);

  /* ForcingFunction for TransferFcn: '<S50>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE = 0.0;
  _rtXdot->TransferFcn_CSTATE += Thermal_system_full_P.TransferFcn_A *
    Thermal_system_full_X.TransferFcn_CSTATE;
  _rtXdot->TransferFcn_CSTATE += Thermal_system_full_B.Saturation_g;

  /* ForcingFunction for TransferFcn: '<S50>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE = 0.0;
  _rtXdot->TransferFcn1_CSTATE += Thermal_system_full_P.TransferFcn1_A *
    Thermal_system_full_X.TransferFcn1_CSTATE;
  _rtXdot->TransferFcn1_CSTATE += Thermal_system_full_B.Divide_bu;

  /* ForcingFunction for TransferFcn: '<S44>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_a = 0.0;
  _rtXdot->TransferFcn_CSTATE_a += Thermal_system_full_P.TransferFcn_A_l *
    Thermal_system_full_X.TransferFcn_CSTATE_a;
  _rtXdot->TransferFcn_CSTATE_a += Thermal_system_full_B.iBMScomputation;

  /* ForcingFunction for TransferFcn: '<S45>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_n = 0.0;
  _rtXdot->TransferFcn_CSTATE_n += Thermal_system_full_P.TransferFcn_A_j *
    Thermal_system_full_X.TransferFcn_CSTATE_n;
  _rtXdot->TransferFcn_CSTATE_n += Thermal_system_full_B.cmd_battery_pumpValue;

  /* ForcingFunction for TransferFcn: '<S48>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_k = 0.0;
  _rtXdot->TransferFcn_CSTATE_k += Thermal_system_full_P.TransferFcn_A_m *
    Thermal_system_full_X.TransferFcn_CSTATE_k;
  _rtXdot->TransferFcn_CSTATE_k += Thermal_system_full_B.cmd_chiller_bypassValue;

  /* ForcingFunction for TransferFcn: '<S51>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE_d = 0.0;
  _rtXdot->TransferFcn1_CSTATE_d += Thermal_system_full_P.TransferFcn1_A_a *
    Thermal_system_full_X.TransferFcn1_CSTATE_d;
  _rtXdot->TransferFcn1_CSTATE_d += Thermal_system_full_B.cmd_fanValue;

  /* ForcingFunction for TransferFcn: '<S56>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_nn = 0.0;
  _rtXdot->TransferFcn_CSTATE_nn += Thermal_system_full_P.TransferFcn_A_jp *
    Thermal_system_full_X.TransferFcn_CSTATE_nn;
  _rtXdot->TransferFcn_CSTATE_nn += Thermal_system_full_B.cmd_motor_pumpValue;

  /* ForcingFunction for TransferFcn: '<S57>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_kv = 0.0;
  _rtXdot->TransferFcn_CSTATE_kv += Thermal_system_full_P.TransferFcn_A_g *
    Thermal_system_full_X.TransferFcn_CSTATE_kv;
  _rtXdot->TransferFcn_CSTATE_kv +=
    Thermal_system_full_B.cmd_parallel_serialValue;

  /* ForcingFunction for TransferFcn: '<S59>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_e = 0.0;
  _rtXdot->TransferFcn_CSTATE_e += Thermal_system_full_P.TransferFcn_A_n *
    Thermal_system_full_X.TransferFcn_CSTATE_e;
  _rtXdot->TransferFcn_CSTATE_e += Thermal_system_full_B.cmd_rad_bypassValue;

  /* ForcingFunction for SimscapeExecutionBlock: '<S354>/STATE_1' */
  simulationData = (NeslSimulationData *)Thermal_system_full_DW.STATE_1_SimData;
  time = Thermal_system_full_M->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 626;
  simulationData->mData->mContStates.mX =
    &Thermal_system_full_X.Thermal_system_fullThermal_Syst[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX =
    &Thermal_system_full_DW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 394;
  simulationData->mData->mModeVector.mX = &Thermal_system_full_DW.STATE_1_Modes
    [0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep
    (Thermal_system_full_M);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&Thermal_system_full_M->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = Thermal_system_full_B.INPUT_1_1_1[0];
  tmp_0[1] = Thermal_system_full_B.INPUT_1_1_1[1];
  tmp_0[2] = Thermal_system_full_B.INPUT_1_1_1[2];
  tmp_0[3] = Thermal_system_full_B.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = Thermal_system_full_B.INPUT_2_1_1[0];
  tmp_0[5] = Thermal_system_full_B.INPUT_2_1_1[1];
  tmp_0[6] = Thermal_system_full_B.INPUT_2_1_1[2];
  tmp_0[7] = Thermal_system_full_B.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = Thermal_system_full_B.INPUT_3_1_1[0];
  tmp_0[9] = Thermal_system_full_B.INPUT_3_1_1[1];
  tmp_0[10] = Thermal_system_full_B.INPUT_3_1_1[2];
  tmp_0[11] = Thermal_system_full_B.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = Thermal_system_full_B.INPUT_4_1_1[0];
  tmp_0[13] = Thermal_system_full_B.INPUT_4_1_1[1];
  tmp_0[14] = Thermal_system_full_B.INPUT_4_1_1[2];
  tmp_0[15] = Thermal_system_full_B.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = Thermal_system_full_B.INPUT_5_1_1[0];
  tmp_0[17] = Thermal_system_full_B.INPUT_5_1_1[1];
  tmp_0[18] = Thermal_system_full_B.INPUT_5_1_1[2];
  tmp_0[19] = Thermal_system_full_B.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = Thermal_system_full_B.INPUT_10_1_1[0];
  tmp_0[21] = Thermal_system_full_B.INPUT_10_1_1[1];
  tmp_0[22] = Thermal_system_full_B.INPUT_10_1_1[2];
  tmp_0[23] = Thermal_system_full_B.INPUT_10_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = Thermal_system_full_B.INPUT_8_1_1[0];
  tmp_0[25] = Thermal_system_full_B.INPUT_8_1_1[1];
  tmp_0[26] = Thermal_system_full_B.INPUT_8_1_1[2];
  tmp_0[27] = Thermal_system_full_B.INPUT_8_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = Thermal_system_full_B.INPUT_7_1_1[0];
  tmp_0[29] = Thermal_system_full_B.INPUT_7_1_1[1];
  tmp_0[30] = Thermal_system_full_B.INPUT_7_1_1[2];
  tmp_0[31] = Thermal_system_full_B.INPUT_7_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = Thermal_system_full_B.INPUT_9_1_1[0];
  tmp_0[33] = Thermal_system_full_B.INPUT_9_1_1[1];
  tmp_0[34] = Thermal_system_full_B.INPUT_9_1_1[2];
  tmp_0[35] = Thermal_system_full_B.INPUT_9_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = Thermal_system_full_B.INPUT_6_1_1[0];
  tmp_0[37] = Thermal_system_full_B.INPUT_6_1_1[1];
  tmp_0[38] = Thermal_system_full_B.INPUT_6_1_1[2];
  tmp_0[39] = Thermal_system_full_B.INPUT_6_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = Thermal_system_full_B.INPUT_11_1_1[0];
  tmp_0[41] = Thermal_system_full_B.INPUT_11_1_1[1];
  tmp_0[42] = Thermal_system_full_B.INPUT_11_1_1[2];
  tmp_0[43] = Thermal_system_full_B.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = Thermal_system_full_B.INPUT_12_1_1[0];
  tmp_0[45] = Thermal_system_full_B.INPUT_12_1_1[1];
  tmp_0[46] = Thermal_system_full_B.INPUT_12_1_1[2];
  tmp_0[47] = Thermal_system_full_B.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = Thermal_system_full_B.INPUT_13_1_1[0];
  tmp_0[49] = Thermal_system_full_B.INPUT_13_1_1[1];
  tmp_0[50] = Thermal_system_full_B.INPUT_13_1_1[2];
  tmp_0[51] = Thermal_system_full_B.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = Thermal_system_full_B.INPUT_14_1_1[0];
  tmp_0[53] = Thermal_system_full_B.INPUT_14_1_1[1];
  tmp_0[54] = Thermal_system_full_B.INPUT_14_1_1[2];
  tmp_0[55] = Thermal_system_full_B.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = Thermal_system_full_B.INPUT_15_1_1[0];
  tmp_0[57] = Thermal_system_full_B.INPUT_15_1_1[1];
  tmp_0[58] = Thermal_system_full_B.INPUT_15_1_1[2];
  tmp_0[59] = Thermal_system_full_B.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = Thermal_system_full_B.INPUT_16_1_1[0];
  tmp_0[61] = Thermal_system_full_B.INPUT_16_1_1[1];
  tmp_0[62] = Thermal_system_full_B.INPUT_16_1_1[2];
  tmp_0[63] = Thermal_system_full_B.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = Thermal_system_full_B.INPUT_17_1_1[0];
  tmp_0[65] = Thermal_system_full_B.INPUT_17_1_1[1];
  tmp_0[66] = Thermal_system_full_B.INPUT_17_1_1[2];
  tmp_0[67] = Thermal_system_full_B.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = Thermal_system_full_B.INPUT_18_1_1[0];
  tmp_0[69] = Thermal_system_full_B.INPUT_18_1_1[1];
  tmp_0[70] = Thermal_system_full_B.INPUT_18_1_1[2];
  tmp_0[71] = Thermal_system_full_B.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = Thermal_system_full_B.INPUT_22_1_1[0];
  tmp_0[73] = Thermal_system_full_B.INPUT_22_1_1[1];
  tmp_0[74] = Thermal_system_full_B.INPUT_22_1_1[2];
  tmp_0[75] = Thermal_system_full_B.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = Thermal_system_full_B.INPUT_20_1_1[0];
  tmp_0[77] = Thermal_system_full_B.INPUT_20_1_1[1];
  tmp_0[78] = Thermal_system_full_B.INPUT_20_1_1[2];
  tmp_0[79] = Thermal_system_full_B.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = Thermal_system_full_B.INPUT_19_1_1[0];
  tmp_0[81] = Thermal_system_full_B.INPUT_19_1_1[1];
  tmp_0[82] = Thermal_system_full_B.INPUT_19_1_1[2];
  tmp_0[83] = Thermal_system_full_B.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = Thermal_system_full_B.INPUT_21_1_1[0];
  tmp_0[85] = Thermal_system_full_B.INPUT_21_1_1[1];
  tmp_0[86] = Thermal_system_full_B.INPUT_21_1_1[2];
  tmp_0[87] = Thermal_system_full_B.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = Thermal_system_full_B.INPUT_23_1_1[0];
  tmp_0[89] = Thermal_system_full_B.INPUT_23_1_1[1];
  tmp_0[90] = Thermal_system_full_B.INPUT_23_1_1[2];
  tmp_0[91] = Thermal_system_full_B.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = Thermal_system_full_B.INPUT_24_1_1[0];
  tmp_0[93] = Thermal_system_full_B.INPUT_24_1_1[1];
  tmp_0[94] = Thermal_system_full_B.INPUT_24_1_1[2];
  tmp_0[95] = Thermal_system_full_B.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  simulationData->mData->mDx.mN = 626;
  simulationData->mData->mDx.mX = &_rtXdot->Thermal_system_fullThermal_Syst[0];
  simulator = (NeslSimulator *)Thermal_system_full_DW.STATE_1_Simulator;
  diagnosticManager = (NeuDiagnosticManager *)
    Thermal_system_full_DW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  is = ne_simulator_method(simulator, NESL_SIM_FORCINGFUNCTION, simulationData,
    diagnosticManager);
  if (is != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(Thermal_system_full_M, msg);
    }
  }

  /* End of ForcingFunction for SimscapeExecutionBlock: '<S354>/STATE_1' */

  /* ForcingFunction for Integrator: '<S40>/Integrator' */
  _rtXdot->Integrator_CSTATE = Thermal_system_full_B.Gain_c;

  /* ForcingFunction for Integrator: '<S41>/Integrator' */
  _rtXdot->Integrator_CSTATE_h = Thermal_system_full_B.EPower_battery;

  /* ForcingFunction for Integrator: '<S41>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = Thermal_system_full_B.EPower_BTM;

  /* ForcingFunction for Integrator: '<S43>/Integrator2' incorporates:
   *  Constant: '<S43>/Constant'
   */
  _rtXdot->Integrator2_CSTATE = Thermal_system_full_P.Constant_Value_m;

  /* ForcingFunction for Integrator: '<S43>/Integrator' */
  _rtXdot->Integrator_CSTATE_d = Thermal_system_full_B.EPower_Compressor;

  /* ForcingFunction for TransferFcn: '<S53>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_b = 0.0;
  _rtXdot->TransferFcn_CSTATE_b += Thermal_system_full_P.TransferFcn_A_gs *
    Thermal_system_full_X.TransferFcn_CSTATE_b;
  _rtXdot->TransferFcn_CSTATE_b += Thermal_system_full_B.cmd_heater;
}

/* MassMatrix for root system: '<Root>' */
void Thermal_system_full_massmatrix(void)
{
  NeslSimulationData *simulationData;
  NeslSimulator *simulator;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  real_T *tmp_2;
  int32_T tmp_3;
  int_T tmp_1[25];
  boolean_T tmp;

  /* MassMatrix for SimscapeExecutionBlock: '<S354>/STATE_1' */
  simulationData = (NeslSimulationData *)Thermal_system_full_DW.STATE_1_SimData;
  time = Thermal_system_full_M->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 626;
  simulationData->mData->mContStates.mX =
    &Thermal_system_full_X.Thermal_system_fullThermal_Syst[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX =
    &Thermal_system_full_DW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 394;
  simulationData->mData->mModeVector.mX = &Thermal_system_full_DW.STATE_1_Modes
    [0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep
    (Thermal_system_full_M);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&Thermal_system_full_M->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = Thermal_system_full_B.INPUT_1_1_1[0];
  tmp_0[1] = Thermal_system_full_B.INPUT_1_1_1[1];
  tmp_0[2] = Thermal_system_full_B.INPUT_1_1_1[2];
  tmp_0[3] = Thermal_system_full_B.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = Thermal_system_full_B.INPUT_2_1_1[0];
  tmp_0[5] = Thermal_system_full_B.INPUT_2_1_1[1];
  tmp_0[6] = Thermal_system_full_B.INPUT_2_1_1[2];
  tmp_0[7] = Thermal_system_full_B.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = Thermal_system_full_B.INPUT_3_1_1[0];
  tmp_0[9] = Thermal_system_full_B.INPUT_3_1_1[1];
  tmp_0[10] = Thermal_system_full_B.INPUT_3_1_1[2];
  tmp_0[11] = Thermal_system_full_B.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = Thermal_system_full_B.INPUT_4_1_1[0];
  tmp_0[13] = Thermal_system_full_B.INPUT_4_1_1[1];
  tmp_0[14] = Thermal_system_full_B.INPUT_4_1_1[2];
  tmp_0[15] = Thermal_system_full_B.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = Thermal_system_full_B.INPUT_5_1_1[0];
  tmp_0[17] = Thermal_system_full_B.INPUT_5_1_1[1];
  tmp_0[18] = Thermal_system_full_B.INPUT_5_1_1[2];
  tmp_0[19] = Thermal_system_full_B.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = Thermal_system_full_B.INPUT_10_1_1[0];
  tmp_0[21] = Thermal_system_full_B.INPUT_10_1_1[1];
  tmp_0[22] = Thermal_system_full_B.INPUT_10_1_1[2];
  tmp_0[23] = Thermal_system_full_B.INPUT_10_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = Thermal_system_full_B.INPUT_8_1_1[0];
  tmp_0[25] = Thermal_system_full_B.INPUT_8_1_1[1];
  tmp_0[26] = Thermal_system_full_B.INPUT_8_1_1[2];
  tmp_0[27] = Thermal_system_full_B.INPUT_8_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = Thermal_system_full_B.INPUT_7_1_1[0];
  tmp_0[29] = Thermal_system_full_B.INPUT_7_1_1[1];
  tmp_0[30] = Thermal_system_full_B.INPUT_7_1_1[2];
  tmp_0[31] = Thermal_system_full_B.INPUT_7_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = Thermal_system_full_B.INPUT_9_1_1[0];
  tmp_0[33] = Thermal_system_full_B.INPUT_9_1_1[1];
  tmp_0[34] = Thermal_system_full_B.INPUT_9_1_1[2];
  tmp_0[35] = Thermal_system_full_B.INPUT_9_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = Thermal_system_full_B.INPUT_6_1_1[0];
  tmp_0[37] = Thermal_system_full_B.INPUT_6_1_1[1];
  tmp_0[38] = Thermal_system_full_B.INPUT_6_1_1[2];
  tmp_0[39] = Thermal_system_full_B.INPUT_6_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = Thermal_system_full_B.INPUT_11_1_1[0];
  tmp_0[41] = Thermal_system_full_B.INPUT_11_1_1[1];
  tmp_0[42] = Thermal_system_full_B.INPUT_11_1_1[2];
  tmp_0[43] = Thermal_system_full_B.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = Thermal_system_full_B.INPUT_12_1_1[0];
  tmp_0[45] = Thermal_system_full_B.INPUT_12_1_1[1];
  tmp_0[46] = Thermal_system_full_B.INPUT_12_1_1[2];
  tmp_0[47] = Thermal_system_full_B.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = Thermal_system_full_B.INPUT_13_1_1[0];
  tmp_0[49] = Thermal_system_full_B.INPUT_13_1_1[1];
  tmp_0[50] = Thermal_system_full_B.INPUT_13_1_1[2];
  tmp_0[51] = Thermal_system_full_B.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = Thermal_system_full_B.INPUT_14_1_1[0];
  tmp_0[53] = Thermal_system_full_B.INPUT_14_1_1[1];
  tmp_0[54] = Thermal_system_full_B.INPUT_14_1_1[2];
  tmp_0[55] = Thermal_system_full_B.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = Thermal_system_full_B.INPUT_15_1_1[0];
  tmp_0[57] = Thermal_system_full_B.INPUT_15_1_1[1];
  tmp_0[58] = Thermal_system_full_B.INPUT_15_1_1[2];
  tmp_0[59] = Thermal_system_full_B.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = Thermal_system_full_B.INPUT_16_1_1[0];
  tmp_0[61] = Thermal_system_full_B.INPUT_16_1_1[1];
  tmp_0[62] = Thermal_system_full_B.INPUT_16_1_1[2];
  tmp_0[63] = Thermal_system_full_B.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = Thermal_system_full_B.INPUT_17_1_1[0];
  tmp_0[65] = Thermal_system_full_B.INPUT_17_1_1[1];
  tmp_0[66] = Thermal_system_full_B.INPUT_17_1_1[2];
  tmp_0[67] = Thermal_system_full_B.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = Thermal_system_full_B.INPUT_18_1_1[0];
  tmp_0[69] = Thermal_system_full_B.INPUT_18_1_1[1];
  tmp_0[70] = Thermal_system_full_B.INPUT_18_1_1[2];
  tmp_0[71] = Thermal_system_full_B.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = Thermal_system_full_B.INPUT_22_1_1[0];
  tmp_0[73] = Thermal_system_full_B.INPUT_22_1_1[1];
  tmp_0[74] = Thermal_system_full_B.INPUT_22_1_1[2];
  tmp_0[75] = Thermal_system_full_B.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = Thermal_system_full_B.INPUT_20_1_1[0];
  tmp_0[77] = Thermal_system_full_B.INPUT_20_1_1[1];
  tmp_0[78] = Thermal_system_full_B.INPUT_20_1_1[2];
  tmp_0[79] = Thermal_system_full_B.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = Thermal_system_full_B.INPUT_19_1_1[0];
  tmp_0[81] = Thermal_system_full_B.INPUT_19_1_1[1];
  tmp_0[82] = Thermal_system_full_B.INPUT_19_1_1[2];
  tmp_0[83] = Thermal_system_full_B.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = Thermal_system_full_B.INPUT_21_1_1[0];
  tmp_0[85] = Thermal_system_full_B.INPUT_21_1_1[1];
  tmp_0[86] = Thermal_system_full_B.INPUT_21_1_1[2];
  tmp_0[87] = Thermal_system_full_B.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = Thermal_system_full_B.INPUT_23_1_1[0];
  tmp_0[89] = Thermal_system_full_B.INPUT_23_1_1[1];
  tmp_0[90] = Thermal_system_full_B.INPUT_23_1_1[2];
  tmp_0[91] = Thermal_system_full_B.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = Thermal_system_full_B.INPUT_24_1_1[0];
  tmp_0[93] = Thermal_system_full_B.INPUT_24_1_1[1];
  tmp_0[94] = Thermal_system_full_B.INPUT_24_1_1[2];
  tmp_0[95] = Thermal_system_full_B.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  tmp_2 = Thermal_system_full_MassMatrix.pr;
  tmp_2 = double_pointer_shift(tmp_2,
    Thermal_system_full_DW.STATE_1_MASS_MATRIX_PR);
  simulationData->mData->mMassMatrixPr.mN = 134;
  simulationData->mData->mMassMatrixPr.mX = tmp_2;
  simulator = (NeslSimulator *)Thermal_system_full_DW.STATE_1_Simulator;
  diagnosticManager = (NeuDiagnosticManager *)
    Thermal_system_full_DW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  tmp_3 = ne_simulator_method(simulator, NESL_SIM_MASSMATRIX, simulationData,
    diagnosticManager);
  if (tmp_3 != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(Thermal_system_full_M, msg);
    }
  }

  /* End of MassMatrix for SimscapeExecutionBlock: '<S354>/STATE_1' */
}

void local_evaluateMassMatrix(RTWSolverInfo *si, real_T *Mdest )
{
  /* Refresh global mass matrix */
  Thermal_system_full_massmatrix();

  /* Copy the mass matrix from system to the destination, if needed. */
  if (Mdest != rtsiGetSolverMassMatrixPr(si)) {
    real_T *Msrc = rtsiGetSolverMassMatrixPr(si);
    int_T nzmax = rtsiGetSolverMassMatrixNzMax(si);
    (void) memcpy(Mdest, Msrc,
                  (uint_T)nzmax*sizeof(real_T));
  }
}

/* Simplified version of numjac.cpp, for use with RTW. */
void local_numjac( RTWSolverInfo *si, real_T *y, const real_T *Fty, real_T *fac,
                  real_T *dFdy )
{
  /* constants */
  real_T THRESH = 1e-6;
  real_T EPS = 2.2e-16;                /* utGetEps(); */
  real_T BL = pow(EPS, 0.75);
  real_T BU = pow(EPS, 0.25);
  real_T FACMIN = pow(EPS, 0.78);
  real_T FACMAX = 0.1;
  int_T nx = 641;
  real_T *x = rtsiGetContStates(si);
  real_T del;
  real_T difmax;
  real_T FdelRowmax;
  real_T temp;
  real_T Fdiff;
  real_T maybe;
  real_T xscale;
  real_T fscale;
  real_T *p;
  int_T rowmax;
  int_T i,j;
  if (x != y)
    (void) memcpy(x, y,
                  (uint_T)nx*sizeof(real_T));
  rtsiSetSolverComputingJacobian(si,true);
  for (p = dFdy, j = 0; j < nx; j++, p += nx) {
    /* Select an increment del for a difference approximation to
       column j of dFdy.  The vector fac accounts for experience
       gained in previous calls to numjac. */
    xscale = fabs(x[j]);
    if (xscale < THRESH)
      xscale = THRESH;
    temp = (x[j] + fac[j]*xscale);
    del = temp - y[j];
    while (del == 0.0) {
      if (fac[j] < FACMAX) {
        fac[j] *= 100.0;
        if (fac[j] > FACMAX)
          fac[j] = FACMAX;
        temp = (x[j] + fac[j]*xscale);
        del = temp - x[j];
      } else {
        del = THRESH;                  /* thresh is nonzero */
        break;
      }
    }

    /* Keep del pointing into region. */
    if (Fty[j] >= 0.0)
      del = fabs(del);
    else
      del = -fabs(del);

    /* Form a difference approximation to column j of dFdy. */
    temp = x[j];
    x[j] += del;
    Thermal_system_full_output();
    rtsiSetdX(si,p);
    Thermal_system_full_forcingfunction();
    x[j] = temp;
    difmax = 0.0;
    rowmax = 0;
    FdelRowmax = p[0];
    temp = 1.0 / del;
    for (i = 0; i < nx; i++) {
      Fdiff = p[i] - Fty[i];
      maybe = fabs(Fdiff);
      if (maybe > difmax) {
        difmax = maybe;
        rowmax = i;
        FdelRowmax = p[i];
      }

      p[i] = temp * Fdiff;
    }

    /* Adjust fac for next call to numjac. */
    if (((FdelRowmax != 0.0) && (Fty[rowmax] != 0.0)) || (difmax == 0.0)) {
      fscale = fabs(FdelRowmax);
      if (fscale < fabs(Fty[rowmax]))
        fscale = fabs(Fty[rowmax]);
      if (difmax <= BL*fscale) {
        /* The difference is small, so increase the increment. */
        fac[j] *= 10.0;
        if (fac[j] > FACMAX)
          fac[j] = FACMAX;
      } else if (difmax > BU*fscale) {
        /* The difference is large, so reduce the increment. */
        fac[j] *= 0.1;
        if (fac[j] < FACMIN)
          fac[j] = FACMIN;
      }
    }
  }

  rtsiSetSolverComputingJacobian(si,false);
}                                      /* end local_numjac */

/*
 * This function updates continuous states using the ODE1be fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  /* Solver Matrices */
  time_T t0 = rtsiGetT(si);
  time_T t1 = t0;
  time_T h = rtsiGetStepSize(si);
  real_T *x1 = rtsiGetContStates(si);
  int_T order = rtsiGetSolverExtrapolationOrder(si);
  int_T numIter = rtsiGetSolverNumberNewtonIterations(si);
  ODE1BE_IntgData *id = (ODE1BE_IntgData *)rtsiGetSolverData(si);
  real_T *x0 = id->x0;
  real_T *f0 = id->f0;
  real_T *f1 = id->f1;
  real_T *Delta = id->Delta;
  real_T *fac = id->fac;
  real_T *dfdx = id->DFDX;
  real_T *W = id->W;
  int_T *pivots = id->pivots;
  real_T *z = id->z;
  int_T *Mpattern_ir = rtsiGetSolverMassMatrixIr(si);
  int_T *Mpattern_jc = rtsiGetSolverMassMatrixJc(si);
  real_T *M = id->M;
  int_T col,row,rowidx;
  int_T i,iter;
  int_T nx = 641;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);

  /* Save the state values at time t in y, we'll use x as ynew. */
  (void) memcpy(x0, x1,
                (uint_T)nx*sizeof(real_T));
  local_evaluateMassMatrix(si,M );

  /* f0 = f(t,y) */
  rtsiSetdX(si, f0);
  Thermal_system_full_forcingfunction();
  local_numjac(si,x0,f0,fac,dfdx );
  Thermal_system_full_output();
  local_evaluateMassMatrix(si,M );
  for (i = 0;i < nx; i++) {
    z[i] = 0;
  }

  t1 = t0 + h;
  rtsiSetT(si, t1);

  /* Newton iteration Loop */
  for (iter = 0; iter < numIter; iter++) {
    real_T *p;

    /* Compute f(t1,x1) */
    rtsiSetdX(si, f1);
    Thermal_system_full_output();
    Thermal_system_full_forcingfunction();

    /* Evaluate state dependent mass matrix if
       this is not the first Newton Iteration*/
    if (iter > 0) {
      Thermal_system_full_output();
      local_evaluateMassMatrix(si,M );
    }

    /* Compute Newton RHS Delta = h*Delta - M*z =
       h*f1 - M*(xn - x0)*/
    for (i = 0; i < nx; i++) {
      Delta[i] = h*f1[i];
    }

    if (iter >= 1) {
      for (col = 0; col < nx; col++) {
        for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++) {
          real_T m_row_col = M[rowidx];
          row = Mpattern_ir[rowidx];
          Delta[row] -= m_row_col*z[col];
        }
      }
    }

    /* LU = (M - hJ) */
    (void) memcpy(W, dfdx,
                  (uint_T)nx*nx*sizeof(real_T));
    for (p = W, i = 0; i < nx*nx; i++, p++) {
      *p *= (-h);
    }

    for (col = 0, p = W; col < nx; col++, p += nx) {
      for (rowidx = Mpattern_jc[col]; rowidx < Mpattern_jc[col+1]; rowidx++) {
        real_T m_row_col = M[rowidx];
        row = Mpattern_ir[rowidx];
        p[row] += m_row_col;
      }
    }

    rt_lu_real(W, nx,
               pivots);

    /* Delta = inv(U)*inv(L)*z */
    rt_ForwardSubstitutionRR_Dbl(W, Delta,
      f1, nx,
      1, pivots,
      1);
    rt_BackwardSubstitutionRR_Dbl(W+nx*nx-1, f1+nx-1,
      Delta, nx,
      1, 0);

    /* Update x1 and z = x - x0 */
    for (i = 0; i < nx; i++) {
      x1[i] += Delta[i];
      z[i] += Delta[i];                /*x1[i] - x0[i];*/
    }
  }

  /* Run whatever FixedStepSolver::PostStep is doing */

  /* t1 = t0 + h; */
  rtsiSetT(si,rtsiGetSolverStopTime(si));
  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

/* Model output function */
void Thermal_system_full_output(void)
{
  NeParameterBundle expl_temp;
  NeslRtpManager *rtpManager;
  NeslSimulationData *simulationData;
  NeslSimulator *simulator;
  NeuDiagnosticManager *diag;
  NeuDiagnosticTree *diagTree;
  char *msg;
  real_T tmp_0[96];
  real_T tmp[19];
  real_T maxV;
  real_T time;
  real_T time_0;
  real_T u1;
  real_T u2;
  real_T *parameterBundle_mRealParameters;
  int_T tmp_2[26];
  int_T tmp_1[25];
  int_T iy;
  boolean_T ok;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* set solver stop time */
    if (!(Thermal_system_full_M->Timing.clockTick0+1)) {
      rtsiSetSolverStopTime(&Thermal_system_full_M->solverInfo,
                            ((Thermal_system_full_M->Timing.clockTickH0 + 1) *
        Thermal_system_full_M->Timing.stepSize0 * 4294967296.0));
    } else {
      rtsiSetSolverStopTime(&Thermal_system_full_M->solverInfo,
                            ((Thermal_system_full_M->Timing.clockTick0 + 1) *
        Thermal_system_full_M->Timing.stepSize0 +
        Thermal_system_full_M->Timing.clockTickH0 *
        Thermal_system_full_M->Timing.stepSize0 * 4294967296.0));
    }
  }                                    /* end MajorTimeStep */

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_M->Timing.t[0] = rtsiGetT
      (&Thermal_system_full_M->solverInfo);
  }

  /* user code (Output function Body) */
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* Function module access point of system <Root>    */
    ap_entry_Thermal_system_full_SIDRoot_TID1();
  }

  /* TransferFcn: '<S50>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn = 0.0;
  Thermal_system_full_B.TransferFcn += Thermal_system_full_P.TransferFcn_C *
    Thermal_system_full_X.TransferFcn_CSTATE;

  /* Gain: '<S50>/Gain1' */
  Thermal_system_full_B.Gain1 = Thermal_system_full_P.Gain1_Gain *
    Thermal_system_full_B.TransferFcn;

  /* Sum: '<S50>/Add' incorporates:
   *  Constant: '<S50>/Constant'
   */
  Thermal_system_full_B.Add = Thermal_system_full_B.Gain1 +
    Thermal_system_full_P.Constant_Value;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S5>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/AngVel_Compressor non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport1_P1_S1(&Thermal_system_full_B.Add);
  }

  /* TransferFcn: '<S50>/Transfer Fcn1' */
  Thermal_system_full_B.TransferFcn1 = 0.0;
  Thermal_system_full_B.TransferFcn1 += Thermal_system_full_P.TransferFcn1_C *
    Thermal_system_full_X.TransferFcn1_CSTATE;

  /* Abs: '<S50>/Abs' */
  Thermal_system_full_B.Abs = fabs(Thermal_system_full_B.TransferFcn1);

  /* Product: '<S43>/MeccPower_Compressor' */
  Thermal_system_full_B.MeccPower_Compressor = Thermal_system_full_B.Add *
    Thermal_system_full_B.Abs;

  /* Gain: '<S43>/EPower_Compressor' */
  Thermal_system_full_B.EPower_Compressor =
    Thermal_system_full_P.EPower_Compressor_Gain *
    Thermal_system_full_B.MeccPower_Compressor;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S6>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/EPower_Compressor non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport2_P1_S1
      (&Thermal_system_full_B.EPower_Compressor);

    /* S-Function (dsmpb_dataoutport): '<S21>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/Torque_Compressor non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport3_P1_S1(&Thermal_system_full_B.Abs);

    /* S-Function (dsmpb_datainport): '<S7>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/I_traction non-bus port 1 */
    ap_read_Thermal_system_full_DataInport1_P1_S1
      (&Thermal_system_full_B.I_tractionValue);
  }

  /* TransferFcn: '<S44>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_o = 0.0;
  Thermal_system_full_B.TransferFcn_o += Thermal_system_full_P.TransferFcn_C_a *
    Thermal_system_full_X.TransferFcn_CSTATE_a;

  /* Sum: '<S44>/i_battery' */
  Thermal_system_full_B.i_battery = Thermal_system_full_B.I_tractionValue +
    Thermal_system_full_B.TransferFcn_o;

  /* SimscapeInputBlock: '<S354>/INPUT_1_1_1' */
  Thermal_system_full_B.INPUT_1_1_1[0] = Thermal_system_full_B.i_battery;
  Thermal_system_full_B.INPUT_1_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_1_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_1_1_1[3] = 0.0;

  /* TransferFcn: '<S45>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_p = 0.0;
  Thermal_system_full_B.TransferFcn_p += Thermal_system_full_P.TransferFcn_C_j *
    Thermal_system_full_X.TransferFcn_CSTATE_n;

  /* Gain: '<S45>/Max Speed [rpm]' */
  Thermal_system_full_B.MaxSpeedrpm = Thermal_system_full_P.pump_speed_max *
    Thermal_system_full_B.TransferFcn_p;

  /* SimscapeInputBlock: '<S354>/INPUT_2_1_1' */
  Thermal_system_full_B.INPUT_2_1_1[0] = 0.10471975511965977 *
    Thermal_system_full_B.MaxSpeedrpm;
  Thermal_system_full_B.INPUT_2_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_2_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_2_1_1[3] = 0.0;

  /* TransferFcn: '<S48>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_k = 0.0;
  Thermal_system_full_B.TransferFcn_k += Thermal_system_full_P.TransferFcn_C_h *
    Thermal_system_full_X.TransferFcn_CSTATE_k;

  /* Gain: '<S48>/Gain' */
  Thermal_system_full_B.Gain = Thermal_system_full_P.Gain_Gain *
    Thermal_system_full_B.TransferFcn_k;

  /* Bias: '<S48>/Bias' */
  Thermal_system_full_B.Bias = Thermal_system_full_B.Gain +
    Thermal_system_full_P.Bias_Bias;

  /* Gain: '<S48>/Max Valve Displacement [m]' */
  Thermal_system_full_B.MaxValveDisplacementm =
    Thermal_system_full_P.coolant_valve_displacement *
    Thermal_system_full_B.Bias;

  /* SimscapeInputBlock: '<S354>/INPUT_4_1_1' */
  Thermal_system_full_B.INPUT_4_1_1[0] =
    Thermal_system_full_B.MaxValveDisplacementm;
  Thermal_system_full_B.INPUT_4_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_4_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_4_1_1[3] = 0.0;

  /* SimscapeInputBlock: '<S354>/INPUT_5_1_1' */
  Thermal_system_full_B.INPUT_5_1_1[0] = Thermal_system_full_B.TransferFcn;
  Thermal_system_full_B.INPUT_5_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_5_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_5_1_1[3] = 0.0;

  /* SimscapeInputBlock: '<S354>/INPUT_10_1_1' incorporates:
   *  Constant: '<S2>/CO2 Fraction'
   */
  Thermal_system_full_B.INPUT_10_1_1[0] =
    Thermal_system_full_P.CO2Fraction_Value;
  Thermal_system_full_B.INPUT_10_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_10_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_10_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_10_1_1[0] ==
        Thermal_system_full_DW.INPUT_10_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_10_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_10_1_1[0];
  }

  Thermal_system_full_B.INPUT_10_1_1[0] =
    Thermal_system_full_DW.INPUT_10_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_10_1_1[3] =
    Thermal_system_full_DW.INPUT_10_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_10_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_8_1_1' incorporates:
   *  Constant: '<S2>/Pressure [MPa]'
   */
  Thermal_system_full_B.INPUT_8_1_1[0] = 1.0E+6 *
    Thermal_system_full_P.PressureMPa_Value;
  Thermal_system_full_B.INPUT_8_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_8_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_8_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_8_1_1[0] ==
        Thermal_system_full_DW.INPUT_8_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_8_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_8_1_1[0];
  }

  Thermal_system_full_B.INPUT_8_1_1[0] =
    Thermal_system_full_DW.INPUT_8_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_8_1_1[3] =
    Thermal_system_full_DW.INPUT_8_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_8_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_7_1_1' incorporates:
   *  Constant: '<S2>/Temperature [degC]'
   */
  Thermal_system_full_B.INPUT_7_1_1[0] = Thermal_system_full_P.T_init + 273.15;
  Thermal_system_full_B.INPUT_7_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_7_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_7_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_7_1_1[0] ==
        Thermal_system_full_DW.INPUT_7_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_7_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_7_1_1[0];
  }

  Thermal_system_full_B.INPUT_7_1_1[0] =
    Thermal_system_full_DW.INPUT_7_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_7_1_1[3] =
    Thermal_system_full_DW.INPUT_7_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_7_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_9_1_1' incorporates:
   *  Constant: '<S2>/Relative Humidity'
   */
  Thermal_system_full_B.INPUT_9_1_1[0] =
    Thermal_system_full_P.RelativeHumidity_Value;
  Thermal_system_full_B.INPUT_9_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_9_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_9_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_9_1_1[0] ==
        Thermal_system_full_DW.INPUT_9_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_9_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_9_1_1[0];
  }

  Thermal_system_full_B.INPUT_9_1_1[0] =
    Thermal_system_full_DW.INPUT_9_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_9_1_1[3] =
    Thermal_system_full_DW.INPUT_9_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_9_1_1' */

  /* TransferFcn: '<S51>/Transfer Fcn1' */
  Thermal_system_full_B.TransferFcn1_m = 0.0;
  Thermal_system_full_B.TransferFcn1_m += Thermal_system_full_P.TransferFcn1_C_b
    * Thermal_system_full_X.TransferFcn1_CSTATE_d;

  /* Gain: '<S51>/Gain' */
  Thermal_system_full_B.Gain_a = Thermal_system_full_P.Gain_Gain_k *
    Thermal_system_full_B.TransferFcn1_m;

  /* SimscapeInputBlock: '<S354>/INPUT_6_1_1' */
  Thermal_system_full_B.INPUT_6_1_1[0] = 0.10471975511965977 *
    Thermal_system_full_B.Gain_a;
  Thermal_system_full_B.INPUT_6_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_6_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_6_1_1[3] = 0.0;

  /* TransferFcn: '<S56>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_f = 0.0;
  Thermal_system_full_B.TransferFcn_f += Thermal_system_full_P.TransferFcn_C_h1 *
    Thermal_system_full_X.TransferFcn_CSTATE_nn;

  /* Gain: '<S56>/Max Speed [rpm]' */
  Thermal_system_full_B.MaxSpeedrpm_d = Thermal_system_full_P.pump_speed_max *
    Thermal_system_full_B.TransferFcn_f;

  /* SimscapeInputBlock: '<S354>/INPUT_15_1_1' */
  Thermal_system_full_B.INPUT_15_1_1[0] = 0.10471975511965977 *
    Thermal_system_full_B.MaxSpeedrpm_d;
  Thermal_system_full_B.INPUT_15_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_15_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_15_1_1[3] = 0.0;

  /* SimscapeInputBlock: '<S354>/INPUT_16_1_1' incorporates:
   *  Constant: '<S2>/Temperature [degC]'
   */
  Thermal_system_full_B.INPUT_16_1_1[0] = Thermal_system_full_P.T_init + 273.15;
  Thermal_system_full_B.INPUT_16_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_16_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_16_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_16_1_1[0] ==
        Thermal_system_full_DW.INPUT_16_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_16_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_16_1_1[0];
  }

  Thermal_system_full_B.INPUT_16_1_1[0] =
    Thermal_system_full_DW.INPUT_16_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_16_1_1[3] =
    Thermal_system_full_DW.INPUT_16_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_16_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_17_1_1' incorporates:
   *  Constant: '<S2>/Temperature [degC]'
   */
  Thermal_system_full_B.INPUT_17_1_1[0] = Thermal_system_full_P.T_init + 273.15;
  Thermal_system_full_B.INPUT_17_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_17_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_17_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_17_1_1[0] ==
        Thermal_system_full_DW.INPUT_17_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_17_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_17_1_1[0];
  }

  Thermal_system_full_B.INPUT_17_1_1[0] =
    Thermal_system_full_DW.INPUT_17_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_17_1_1[3] =
    Thermal_system_full_DW.INPUT_17_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_17_1_1' */

  /* TransferFcn: '<S57>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_d = 0.0;
  Thermal_system_full_B.TransferFcn_d += Thermal_system_full_P.TransferFcn_C_an *
    Thermal_system_full_X.TransferFcn_CSTATE_kv;

  /* Gain: '<S57>/Gain' */
  Thermal_system_full_B.Gain_i = Thermal_system_full_P.Gain_Gain_c *
    Thermal_system_full_B.TransferFcn_d;

  /* Bias: '<S57>/Bias' */
  Thermal_system_full_B.Bias_i = Thermal_system_full_B.Gain_i +
    Thermal_system_full_P.Bias_Bias_b;

  /* Gain: '<S57>/Max Valve Displacement [m]' */
  Thermal_system_full_B.MaxValveDisplacementm_d =
    Thermal_system_full_P.coolant_valve_displacement *
    Thermal_system_full_B.Bias_i;

  /* SimscapeInputBlock: '<S354>/INPUT_18_1_1' */
  Thermal_system_full_B.INPUT_18_1_1[0] =
    Thermal_system_full_B.MaxValveDisplacementm_d;
  Thermal_system_full_B.INPUT_18_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_18_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_18_1_1[3] = 0.0;

  /* SimscapeInputBlock: '<S354>/INPUT_22_1_1' incorporates:
   *  Constant: '<S2>/CO2 Fraction'
   */
  Thermal_system_full_B.INPUT_22_1_1[0] =
    Thermal_system_full_P.CO2Fraction_Value;
  Thermal_system_full_B.INPUT_22_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_22_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_22_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_22_1_1[0] ==
        Thermal_system_full_DW.INPUT_22_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_22_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_22_1_1[0];
  }

  Thermal_system_full_B.INPUT_22_1_1[0] =
    Thermal_system_full_DW.INPUT_22_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_22_1_1[3] =
    Thermal_system_full_DW.INPUT_22_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_22_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_20_1_1' incorporates:
   *  Constant: '<S2>/Pressure [MPa]'
   */
  Thermal_system_full_B.INPUT_20_1_1[0] = 1.0E+6 *
    Thermal_system_full_P.PressureMPa_Value;
  Thermal_system_full_B.INPUT_20_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_20_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_20_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_20_1_1[0] ==
        Thermal_system_full_DW.INPUT_20_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_20_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_20_1_1[0];
  }

  Thermal_system_full_B.INPUT_20_1_1[0] =
    Thermal_system_full_DW.INPUT_20_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_20_1_1[3] =
    Thermal_system_full_DW.INPUT_20_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_20_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_19_1_1' incorporates:
   *  Constant: '<S2>/Temperature [degC]'
   */
  Thermal_system_full_B.INPUT_19_1_1[0] = Thermal_system_full_P.T_init + 273.15;
  Thermal_system_full_B.INPUT_19_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_19_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_19_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_19_1_1[0] ==
        Thermal_system_full_DW.INPUT_19_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_19_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_19_1_1[0];
  }

  Thermal_system_full_B.INPUT_19_1_1[0] =
    Thermal_system_full_DW.INPUT_19_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_19_1_1[3] =
    Thermal_system_full_DW.INPUT_19_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_19_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_21_1_1' incorporates:
   *  Constant: '<S2>/Relative Humidity'
   */
  Thermal_system_full_B.INPUT_21_1_1[0] =
    Thermal_system_full_P.RelativeHumidity_Value;
  Thermal_system_full_B.INPUT_21_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_21_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_21_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_21_1_1[0] ==
        Thermal_system_full_DW.INPUT_21_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_21_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_21_1_1[0];
  }

  Thermal_system_full_B.INPUT_21_1_1[0] =
    Thermal_system_full_DW.INPUT_21_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_21_1_1[3] =
    Thermal_system_full_DW.INPUT_21_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_21_1_1' */
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_datainport): '<S33>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/v_vehicle non-bus port 1 */
    ap_read_Thermal_system_full_DataInport2_P1_S1
      (&Thermal_system_full_B.v_vehicleValue);
  }

  /* SimscapeInputBlock: '<S354>/INPUT_23_1_1' */
  Thermal_system_full_B.INPUT_23_1_1[0] = Thermal_system_full_B.v_vehicleValue;
  Thermal_system_full_B.INPUT_23_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_23_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_23_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_23_1_1[0] ==
        Thermal_system_full_DW.INPUT_23_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_23_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_23_1_1[0];
  }

  Thermal_system_full_B.INPUT_23_1_1[0] =
    Thermal_system_full_DW.INPUT_23_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_23_1_1[3] =
    Thermal_system_full_DW.INPUT_23_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_23_1_1' */

  /* TransferFcn: '<S59>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_kl = 0.0;
  Thermal_system_full_B.TransferFcn_kl += Thermal_system_full_P.TransferFcn_C_k *
    Thermal_system_full_X.TransferFcn_CSTATE_e;

  /* Gain: '<S59>/Gain' */
  Thermal_system_full_B.Gain_g = Thermal_system_full_P.Gain_Gain_d *
    Thermal_system_full_B.TransferFcn_kl;

  /* Bias: '<S59>/Bias' */
  Thermal_system_full_B.Bias_p = Thermal_system_full_B.Gain_g +
    Thermal_system_full_P.Bias_Bias_p;

  /* Gain: '<S59>/Max Valve Displacement [m]' */
  Thermal_system_full_B.MaxValveDisplacementm_g =
    Thermal_system_full_P.coolant_valve_displacement *
    Thermal_system_full_B.Bias_p;

  /* SimscapeInputBlock: '<S354>/INPUT_24_1_1' */
  Thermal_system_full_B.INPUT_24_1_1[0] =
    Thermal_system_full_B.MaxValveDisplacementm_g;
  Thermal_system_full_B.INPUT_24_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_24_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_24_1_1[3] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* SimscapeRtp: '<S60>/RTP_1' incorporates:
     *  Constant: '<S46>/Subsystem_around_RTP_9DA0F773_T'
     *  Constant: '<S52>/Subsystem_around_RTP_FC3E5730_T'
     *  Constant: '<S53>/Subsystem_around_RTP_BE639B65_T_I'
     *  Constant: '<S53>/Subsystem_around_RTP_BE639B65_p_I'
     *  Constant: '<S53>/Subsystem_around_RTP_D0AAEABB_T'
     *  Constant: '<S54>/Subsystem_around_RTP_5217DA0C_T'
     *  Constant: '<S55>/Subsystem_around_RTP_33E9E370_T'
     *  Constant: '<S57>/Subsystem_around_RTP_216ADFBB_T_gas_tank'
     *  Constant: '<S57>/Subsystem_around_RTP_216ADFBB_T_liquid_tank'
     *  Constant: '<S57>/Subsystem_around_RTP_216ADFBB_p_gas_tank'
     *  Constant: '<S57>/Subsystem_around_RTP_216ADFBB_volume_liquid'
     *  Constant: '<S57>/Subsystem_around_RTP_40839966_T_gas_tank'
     *  Constant: '<S57>/Subsystem_around_RTP_40839966_T_liquid_tank'
     *  Constant: '<S57>/Subsystem_around_RTP_40839966_p_gas_tank'
     *  Constant: '<S57>/Subsystem_around_RTP_40839966_volume_liquid'
     *  Constant: '<S76>/Subsystem_around_RTP_017CE573_T'
     *  Constant: '<S86>/Subsystem_around_RTP_B447800A_T'
     *  Constant: '<S90>/Subsystem_around_RTP_6E7E5EE2_T'
     *  Constant: '<S94>/Subsystem_around_RTP_05404CB9_T'
     */
    if (Thermal_system_full_DW.RTP_1_SetParametersNeeded) {
      tmp[0] = Thermal_system_full_P.RTP_017CE573_T_Value;
      tmp[1] = Thermal_system_full_P.RTP_05404CB9_T_Value;
      tmp[2] = Thermal_system_full_P.coolant_T_init;
      tmp[3] = Thermal_system_full_P.coolant_T_init;
      tmp[4] = Thermal_system_full_P.coolant_p_init;
      maxV = 0.25 * Thermal_system_full_P.coolant_tank_volume;
      tmp[5] = maxV;
      tmp[6] = Thermal_system_full_P.coolant_T_init;
      tmp[7] = Thermal_system_full_P.coolant_T_init;
      tmp[8] = Thermal_system_full_P.coolant_T_init;
      tmp[9] = Thermal_system_full_P.coolant_p_init;
      maxV = 0.25 * Thermal_system_full_P.coolant_tank_volume;
      tmp[10] = maxV;
      tmp[11] = Thermal_system_full_P.coolant_T_init;
      tmp[12] = Thermal_system_full_P.RTP_6E7E5EE2_T_Value;
      tmp[13] = Thermal_system_full_P.coolant_T_init;
      tmp[14] = Thermal_system_full_P.RTP_B447800A_T_Value;
      tmp[15] = Thermal_system_full_P.coolant_T_init;
      tmp[16] = Thermal_system_full_P.coolant_p_init;
      tmp[17] = Thermal_system_full_P.coolant_T_init;
      tmp[18] = Thermal_system_full_P.coolant_T_init;
      parameterBundle_mRealParameters = &tmp[0];
      rtpManager = (NeslRtpManager *)Thermal_system_full_DW.RTP_1_RtpManager;
      diag = rtw_create_diagnostics();
      diagTree = neu_diagnostic_manager_get_initial_tree(diag);
      expl_temp.mRealParameters.mN = 19;
      expl_temp.mRealParameters.mX = parameterBundle_mRealParameters;
      expl_temp.mLogicalParameters.mN = 0;
      expl_temp.mLogicalParameters.mX = NULL;
      expl_temp.mIntegerParameters.mN = 0;
      expl_temp.mIntegerParameters.mX = NULL;
      expl_temp.mIndexParameters.mN = 0;
      expl_temp.mIndexParameters.mX = NULL;
      ok = nesl_rtp_manager_set_rtps(rtpManager, Thermal_system_full_M->
        Timing.t[0], expl_temp, diag);
      if (!ok) {
        ok = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
        if (ok) {
          msg = rtw_diagnostics_msg(diagTree);
          rtmSetErrorStatus(Thermal_system_full_M, msg);
        }
      }
    }

    Thermal_system_full_DW.RTP_1_SetParametersNeeded = false;

    /* End of SimscapeRtp: '<S60>/RTP_1' */
  }

  /* SimscapeExecutionBlock: '<S354>/STATE_1' */
  simulationData = (NeslSimulationData *)Thermal_system_full_DW.STATE_1_SimData;
  time = Thermal_system_full_M->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 626;
  simulationData->mData->mContStates.mX =
    &Thermal_system_full_X.Thermal_system_fullThermal_Syst[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX =
    &Thermal_system_full_DW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 394;
  simulationData->mData->mModeVector.mX = &Thermal_system_full_DW.STATE_1_Modes
    [0];
  ok = false;
  simulationData->mData->mFoundZcEvents = ok;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep
    (Thermal_system_full_M);
  ok = false;
  simulationData->mData->mIsSolverAssertCheck = ok;
  simulationData->mData->mIsSolverCheckingCIC = false;
  ok = rtsiIsSolverComputingJacobian(&Thermal_system_full_M->solverInfo);
  simulationData->mData->mIsComputingJacobian = ok;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = Thermal_system_full_B.INPUT_1_1_1[0];
  tmp_0[1] = Thermal_system_full_B.INPUT_1_1_1[1];
  tmp_0[2] = Thermal_system_full_B.INPUT_1_1_1[2];
  tmp_0[3] = Thermal_system_full_B.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = Thermal_system_full_B.INPUT_2_1_1[0];
  tmp_0[5] = Thermal_system_full_B.INPUT_2_1_1[1];
  tmp_0[6] = Thermal_system_full_B.INPUT_2_1_1[2];
  tmp_0[7] = Thermal_system_full_B.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = Thermal_system_full_B.INPUT_3_1_1[0];
  tmp_0[9] = Thermal_system_full_B.INPUT_3_1_1[1];
  tmp_0[10] = Thermal_system_full_B.INPUT_3_1_1[2];
  tmp_0[11] = Thermal_system_full_B.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = Thermal_system_full_B.INPUT_4_1_1[0];
  tmp_0[13] = Thermal_system_full_B.INPUT_4_1_1[1];
  tmp_0[14] = Thermal_system_full_B.INPUT_4_1_1[2];
  tmp_0[15] = Thermal_system_full_B.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = Thermal_system_full_B.INPUT_5_1_1[0];
  tmp_0[17] = Thermal_system_full_B.INPUT_5_1_1[1];
  tmp_0[18] = Thermal_system_full_B.INPUT_5_1_1[2];
  tmp_0[19] = Thermal_system_full_B.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = Thermal_system_full_B.INPUT_10_1_1[0];
  tmp_0[21] = Thermal_system_full_B.INPUT_10_1_1[1];
  tmp_0[22] = Thermal_system_full_B.INPUT_10_1_1[2];
  tmp_0[23] = Thermal_system_full_B.INPUT_10_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = Thermal_system_full_B.INPUT_8_1_1[0];
  tmp_0[25] = Thermal_system_full_B.INPUT_8_1_1[1];
  tmp_0[26] = Thermal_system_full_B.INPUT_8_1_1[2];
  tmp_0[27] = Thermal_system_full_B.INPUT_8_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = Thermal_system_full_B.INPUT_7_1_1[0];
  tmp_0[29] = Thermal_system_full_B.INPUT_7_1_1[1];
  tmp_0[30] = Thermal_system_full_B.INPUT_7_1_1[2];
  tmp_0[31] = Thermal_system_full_B.INPUT_7_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = Thermal_system_full_B.INPUT_9_1_1[0];
  tmp_0[33] = Thermal_system_full_B.INPUT_9_1_1[1];
  tmp_0[34] = Thermal_system_full_B.INPUT_9_1_1[2];
  tmp_0[35] = Thermal_system_full_B.INPUT_9_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = Thermal_system_full_B.INPUT_6_1_1[0];
  tmp_0[37] = Thermal_system_full_B.INPUT_6_1_1[1];
  tmp_0[38] = Thermal_system_full_B.INPUT_6_1_1[2];
  tmp_0[39] = Thermal_system_full_B.INPUT_6_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = Thermal_system_full_B.INPUT_11_1_1[0];
  tmp_0[41] = Thermal_system_full_B.INPUT_11_1_1[1];
  tmp_0[42] = Thermal_system_full_B.INPUT_11_1_1[2];
  tmp_0[43] = Thermal_system_full_B.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = Thermal_system_full_B.INPUT_12_1_1[0];
  tmp_0[45] = Thermal_system_full_B.INPUT_12_1_1[1];
  tmp_0[46] = Thermal_system_full_B.INPUT_12_1_1[2];
  tmp_0[47] = Thermal_system_full_B.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = Thermal_system_full_B.INPUT_13_1_1[0];
  tmp_0[49] = Thermal_system_full_B.INPUT_13_1_1[1];
  tmp_0[50] = Thermal_system_full_B.INPUT_13_1_1[2];
  tmp_0[51] = Thermal_system_full_B.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = Thermal_system_full_B.INPUT_14_1_1[0];
  tmp_0[53] = Thermal_system_full_B.INPUT_14_1_1[1];
  tmp_0[54] = Thermal_system_full_B.INPUT_14_1_1[2];
  tmp_0[55] = Thermal_system_full_B.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = Thermal_system_full_B.INPUT_15_1_1[0];
  tmp_0[57] = Thermal_system_full_B.INPUT_15_1_1[1];
  tmp_0[58] = Thermal_system_full_B.INPUT_15_1_1[2];
  tmp_0[59] = Thermal_system_full_B.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = Thermal_system_full_B.INPUT_16_1_1[0];
  tmp_0[61] = Thermal_system_full_B.INPUT_16_1_1[1];
  tmp_0[62] = Thermal_system_full_B.INPUT_16_1_1[2];
  tmp_0[63] = Thermal_system_full_B.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = Thermal_system_full_B.INPUT_17_1_1[0];
  tmp_0[65] = Thermal_system_full_B.INPUT_17_1_1[1];
  tmp_0[66] = Thermal_system_full_B.INPUT_17_1_1[2];
  tmp_0[67] = Thermal_system_full_B.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = Thermal_system_full_B.INPUT_18_1_1[0];
  tmp_0[69] = Thermal_system_full_B.INPUT_18_1_1[1];
  tmp_0[70] = Thermal_system_full_B.INPUT_18_1_1[2];
  tmp_0[71] = Thermal_system_full_B.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = Thermal_system_full_B.INPUT_22_1_1[0];
  tmp_0[73] = Thermal_system_full_B.INPUT_22_1_1[1];
  tmp_0[74] = Thermal_system_full_B.INPUT_22_1_1[2];
  tmp_0[75] = Thermal_system_full_B.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = Thermal_system_full_B.INPUT_20_1_1[0];
  tmp_0[77] = Thermal_system_full_B.INPUT_20_1_1[1];
  tmp_0[78] = Thermal_system_full_B.INPUT_20_1_1[2];
  tmp_0[79] = Thermal_system_full_B.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = Thermal_system_full_B.INPUT_19_1_1[0];
  tmp_0[81] = Thermal_system_full_B.INPUT_19_1_1[1];
  tmp_0[82] = Thermal_system_full_B.INPUT_19_1_1[2];
  tmp_0[83] = Thermal_system_full_B.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = Thermal_system_full_B.INPUT_21_1_1[0];
  tmp_0[85] = Thermal_system_full_B.INPUT_21_1_1[1];
  tmp_0[86] = Thermal_system_full_B.INPUT_21_1_1[2];
  tmp_0[87] = Thermal_system_full_B.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = Thermal_system_full_B.INPUT_23_1_1[0];
  tmp_0[89] = Thermal_system_full_B.INPUT_23_1_1[1];
  tmp_0[90] = Thermal_system_full_B.INPUT_23_1_1[2];
  tmp_0[91] = Thermal_system_full_B.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = Thermal_system_full_B.INPUT_24_1_1[0];
  tmp_0[93] = Thermal_system_full_B.INPUT_24_1_1[1];
  tmp_0[94] = Thermal_system_full_B.INPUT_24_1_1[2];
  tmp_0[95] = Thermal_system_full_B.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  simulationData->mData->mOutputs.mN = 1020;
  simulationData->mData->mOutputs.mX = &Thermal_system_full_B.STATE_1[0];
  simulationData->mData->mSampleHits.mN = 0;
  simulationData->mData->mSampleHits.mX = NULL;
  simulationData->mData->mIsFundamentalSampleHit = false;
  simulationData->mData->mTolerances.mN = 0;
  simulationData->mData->mTolerances.mX = NULL;
  simulationData->mData->mCstateHasChanged = false;
  simulator = (NeslSimulator *)Thermal_system_full_DW.STATE_1_Simulator;
  diag = (NeuDiagnosticManager *)Thermal_system_full_DW.STATE_1_DiagMgr;
  diagTree = neu_diagnostic_manager_get_initial_tree(diag);
  iy = ne_simulator_method(simulator, NESL_SIM_OUTPUTS, simulationData, diag);
  if (iy != 0) {
    ok = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
    if (ok) {
      msg = rtw_diagnostics_msg(diagTree);
      rtmSetErrorStatus(Thermal_system_full_M, msg);
    }
  }

  /* End of SimscapeExecutionBlock: '<S354>/STATE_1' */

  /* SimscapeExecutionBlock: '<S354>/OUTPUT_1_0' */
  simulationData = (NeslSimulationData *)
    Thermal_system_full_DW.OUTPUT_1_0_SimData;
  time_0 = Thermal_system_full_M->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time_0;
  simulationData->mData->mContStates.mN = 0;
  simulationData->mData->mContStates.mX = NULL;
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX =
    &Thermal_system_full_DW.OUTPUT_1_0_Discrete;
  simulationData->mData->mModeVector.mN = 0;
  simulationData->mData->mModeVector.mX =
    &Thermal_system_full_DW.OUTPUT_1_0_Modes;
  ok = false;
  simulationData->mData->mFoundZcEvents = ok;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep
    (Thermal_system_full_M);
  ok = false;
  simulationData->mData->mIsSolverAssertCheck = ok;
  simulationData->mData->mIsSolverCheckingCIC = false;
  simulationData->mData->mIsComputingJacobian = false;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_2[0] = 0;
  Thermal_system_full_B.dv[0] = Thermal_system_full_B.INPUT_1_1_1[0];
  Thermal_system_full_B.dv[1] = Thermal_system_full_B.INPUT_1_1_1[1];
  Thermal_system_full_B.dv[2] = Thermal_system_full_B.INPUT_1_1_1[2];
  Thermal_system_full_B.dv[3] = Thermal_system_full_B.INPUT_1_1_1[3];
  tmp_2[1] = 4;
  Thermal_system_full_B.dv[4] = Thermal_system_full_B.INPUT_2_1_1[0];
  Thermal_system_full_B.dv[5] = Thermal_system_full_B.INPUT_2_1_1[1];
  Thermal_system_full_B.dv[6] = Thermal_system_full_B.INPUT_2_1_1[2];
  Thermal_system_full_B.dv[7] = Thermal_system_full_B.INPUT_2_1_1[3];
  tmp_2[2] = 8;
  Thermal_system_full_B.dv[8] = Thermal_system_full_B.INPUT_3_1_1[0];
  Thermal_system_full_B.dv[9] = Thermal_system_full_B.INPUT_3_1_1[1];
  Thermal_system_full_B.dv[10] = Thermal_system_full_B.INPUT_3_1_1[2];
  Thermal_system_full_B.dv[11] = Thermal_system_full_B.INPUT_3_1_1[3];
  tmp_2[3] = 12;
  Thermal_system_full_B.dv[12] = Thermal_system_full_B.INPUT_4_1_1[0];
  Thermal_system_full_B.dv[13] = Thermal_system_full_B.INPUT_4_1_1[1];
  Thermal_system_full_B.dv[14] = Thermal_system_full_B.INPUT_4_1_1[2];
  Thermal_system_full_B.dv[15] = Thermal_system_full_B.INPUT_4_1_1[3];
  tmp_2[4] = 16;
  Thermal_system_full_B.dv[16] = Thermal_system_full_B.INPUT_5_1_1[0];
  Thermal_system_full_B.dv[17] = Thermal_system_full_B.INPUT_5_1_1[1];
  Thermal_system_full_B.dv[18] = Thermal_system_full_B.INPUT_5_1_1[2];
  Thermal_system_full_B.dv[19] = Thermal_system_full_B.INPUT_5_1_1[3];
  tmp_2[5] = 20;
  Thermal_system_full_B.dv[20] = Thermal_system_full_B.INPUT_10_1_1[0];
  Thermal_system_full_B.dv[21] = Thermal_system_full_B.INPUT_10_1_1[1];
  Thermal_system_full_B.dv[22] = Thermal_system_full_B.INPUT_10_1_1[2];
  Thermal_system_full_B.dv[23] = Thermal_system_full_B.INPUT_10_1_1[3];
  tmp_2[6] = 24;
  Thermal_system_full_B.dv[24] = Thermal_system_full_B.INPUT_8_1_1[0];
  Thermal_system_full_B.dv[25] = Thermal_system_full_B.INPUT_8_1_1[1];
  Thermal_system_full_B.dv[26] = Thermal_system_full_B.INPUT_8_1_1[2];
  Thermal_system_full_B.dv[27] = Thermal_system_full_B.INPUT_8_1_1[3];
  tmp_2[7] = 28;
  Thermal_system_full_B.dv[28] = Thermal_system_full_B.INPUT_7_1_1[0];
  Thermal_system_full_B.dv[29] = Thermal_system_full_B.INPUT_7_1_1[1];
  Thermal_system_full_B.dv[30] = Thermal_system_full_B.INPUT_7_1_1[2];
  Thermal_system_full_B.dv[31] = Thermal_system_full_B.INPUT_7_1_1[3];
  tmp_2[8] = 32;
  Thermal_system_full_B.dv[32] = Thermal_system_full_B.INPUT_9_1_1[0];
  Thermal_system_full_B.dv[33] = Thermal_system_full_B.INPUT_9_1_1[1];
  Thermal_system_full_B.dv[34] = Thermal_system_full_B.INPUT_9_1_1[2];
  Thermal_system_full_B.dv[35] = Thermal_system_full_B.INPUT_9_1_1[3];
  tmp_2[9] = 36;
  Thermal_system_full_B.dv[36] = Thermal_system_full_B.INPUT_6_1_1[0];
  Thermal_system_full_B.dv[37] = Thermal_system_full_B.INPUT_6_1_1[1];
  Thermal_system_full_B.dv[38] = Thermal_system_full_B.INPUT_6_1_1[2];
  Thermal_system_full_B.dv[39] = Thermal_system_full_B.INPUT_6_1_1[3];
  tmp_2[10] = 40;
  Thermal_system_full_B.dv[40] = Thermal_system_full_B.INPUT_11_1_1[0];
  Thermal_system_full_B.dv[41] = Thermal_system_full_B.INPUT_11_1_1[1];
  Thermal_system_full_B.dv[42] = Thermal_system_full_B.INPUT_11_1_1[2];
  Thermal_system_full_B.dv[43] = Thermal_system_full_B.INPUT_11_1_1[3];
  tmp_2[11] = 44;
  Thermal_system_full_B.dv[44] = Thermal_system_full_B.INPUT_12_1_1[0];
  Thermal_system_full_B.dv[45] = Thermal_system_full_B.INPUT_12_1_1[1];
  Thermal_system_full_B.dv[46] = Thermal_system_full_B.INPUT_12_1_1[2];
  Thermal_system_full_B.dv[47] = Thermal_system_full_B.INPUT_12_1_1[3];
  tmp_2[12] = 48;
  Thermal_system_full_B.dv[48] = Thermal_system_full_B.INPUT_13_1_1[0];
  Thermal_system_full_B.dv[49] = Thermal_system_full_B.INPUT_13_1_1[1];
  Thermal_system_full_B.dv[50] = Thermal_system_full_B.INPUT_13_1_1[2];
  Thermal_system_full_B.dv[51] = Thermal_system_full_B.INPUT_13_1_1[3];
  tmp_2[13] = 52;
  Thermal_system_full_B.dv[52] = Thermal_system_full_B.INPUT_14_1_1[0];
  Thermal_system_full_B.dv[53] = Thermal_system_full_B.INPUT_14_1_1[1];
  Thermal_system_full_B.dv[54] = Thermal_system_full_B.INPUT_14_1_1[2];
  Thermal_system_full_B.dv[55] = Thermal_system_full_B.INPUT_14_1_1[3];
  tmp_2[14] = 56;
  Thermal_system_full_B.dv[56] = Thermal_system_full_B.INPUT_15_1_1[0];
  Thermal_system_full_B.dv[57] = Thermal_system_full_B.INPUT_15_1_1[1];
  Thermal_system_full_B.dv[58] = Thermal_system_full_B.INPUT_15_1_1[2];
  Thermal_system_full_B.dv[59] = Thermal_system_full_B.INPUT_15_1_1[3];
  tmp_2[15] = 60;
  Thermal_system_full_B.dv[60] = Thermal_system_full_B.INPUT_16_1_1[0];
  Thermal_system_full_B.dv[61] = Thermal_system_full_B.INPUT_16_1_1[1];
  Thermal_system_full_B.dv[62] = Thermal_system_full_B.INPUT_16_1_1[2];
  Thermal_system_full_B.dv[63] = Thermal_system_full_B.INPUT_16_1_1[3];
  tmp_2[16] = 64;
  Thermal_system_full_B.dv[64] = Thermal_system_full_B.INPUT_17_1_1[0];
  Thermal_system_full_B.dv[65] = Thermal_system_full_B.INPUT_17_1_1[1];
  Thermal_system_full_B.dv[66] = Thermal_system_full_B.INPUT_17_1_1[2];
  Thermal_system_full_B.dv[67] = Thermal_system_full_B.INPUT_17_1_1[3];
  tmp_2[17] = 68;
  Thermal_system_full_B.dv[68] = Thermal_system_full_B.INPUT_18_1_1[0];
  Thermal_system_full_B.dv[69] = Thermal_system_full_B.INPUT_18_1_1[1];
  Thermal_system_full_B.dv[70] = Thermal_system_full_B.INPUT_18_1_1[2];
  Thermal_system_full_B.dv[71] = Thermal_system_full_B.INPUT_18_1_1[3];
  tmp_2[18] = 72;
  Thermal_system_full_B.dv[72] = Thermal_system_full_B.INPUT_22_1_1[0];
  Thermal_system_full_B.dv[73] = Thermal_system_full_B.INPUT_22_1_1[1];
  Thermal_system_full_B.dv[74] = Thermal_system_full_B.INPUT_22_1_1[2];
  Thermal_system_full_B.dv[75] = Thermal_system_full_B.INPUT_22_1_1[3];
  tmp_2[19] = 76;
  Thermal_system_full_B.dv[76] = Thermal_system_full_B.INPUT_20_1_1[0];
  Thermal_system_full_B.dv[77] = Thermal_system_full_B.INPUT_20_1_1[1];
  Thermal_system_full_B.dv[78] = Thermal_system_full_B.INPUT_20_1_1[2];
  Thermal_system_full_B.dv[79] = Thermal_system_full_B.INPUT_20_1_1[3];
  tmp_2[20] = 80;
  Thermal_system_full_B.dv[80] = Thermal_system_full_B.INPUT_19_1_1[0];
  Thermal_system_full_B.dv[81] = Thermal_system_full_B.INPUT_19_1_1[1];
  Thermal_system_full_B.dv[82] = Thermal_system_full_B.INPUT_19_1_1[2];
  Thermal_system_full_B.dv[83] = Thermal_system_full_B.INPUT_19_1_1[3];
  tmp_2[21] = 84;
  Thermal_system_full_B.dv[84] = Thermal_system_full_B.INPUT_21_1_1[0];
  Thermal_system_full_B.dv[85] = Thermal_system_full_B.INPUT_21_1_1[1];
  Thermal_system_full_B.dv[86] = Thermal_system_full_B.INPUT_21_1_1[2];
  Thermal_system_full_B.dv[87] = Thermal_system_full_B.INPUT_21_1_1[3];
  tmp_2[22] = 88;
  Thermal_system_full_B.dv[88] = Thermal_system_full_B.INPUT_23_1_1[0];
  Thermal_system_full_B.dv[89] = Thermal_system_full_B.INPUT_23_1_1[1];
  Thermal_system_full_B.dv[90] = Thermal_system_full_B.INPUT_23_1_1[2];
  Thermal_system_full_B.dv[91] = Thermal_system_full_B.INPUT_23_1_1[3];
  tmp_2[23] = 92;
  Thermal_system_full_B.dv[92] = Thermal_system_full_B.INPUT_24_1_1[0];
  Thermal_system_full_B.dv[93] = Thermal_system_full_B.INPUT_24_1_1[1];
  Thermal_system_full_B.dv[94] = Thermal_system_full_B.INPUT_24_1_1[2];
  Thermal_system_full_B.dv[95] = Thermal_system_full_B.INPUT_24_1_1[3];
  tmp_2[24] = 96;
  memcpy(&Thermal_system_full_B.dv[96], &Thermal_system_full_B.STATE_1[0], 1020U
         * sizeof(real_T));
  tmp_2[25] = 1116;
  simulationData->mData->mInputValues.mN = 1116;
  simulationData->mData->mInputValues.mX = &Thermal_system_full_B.dv[0];
  simulationData->mData->mInputOffsets.mN = 26;
  simulationData->mData->mInputOffsets.mX = &tmp_2[0];
  simulationData->mData->mOutputs.mN = 103;
  simulationData->mData->mOutputs.mX = &Thermal_system_full_B.OUTPUT_1_0[0];
  simulationData->mData->mSampleHits.mN = 0;
  simulationData->mData->mSampleHits.mX = NULL;
  simulationData->mData->mIsFundamentalSampleHit = false;
  simulationData->mData->mTolerances.mN = 0;
  simulationData->mData->mTolerances.mX = NULL;
  simulationData->mData->mCstateHasChanged = false;
  simulator = (NeslSimulator *)Thermal_system_full_DW.OUTPUT_1_0_Simulator;
  diag = (NeuDiagnosticManager *)Thermal_system_full_DW.OUTPUT_1_0_DiagMgr;
  diagTree = neu_diagnostic_manager_get_initial_tree(diag);
  iy = ne_simulator_method(simulator, NESL_SIM_OUTPUTS, simulationData, diag);
  if (iy != 0) {
    ok = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
    if (ok) {
      msg = rtw_diagnostics_msg(diagTree);
      rtmSetErrorStatus(Thermal_system_full_M, msg);
    }
  }

  /* End of SimscapeExecutionBlock: '<S354>/OUTPUT_1_0' */
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S30>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/i_battery non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport4_P1_S1
      (&Thermal_system_full_B.i_battery);

    /* S-Function (dsmpb_dataoutport): '<S31>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/p_chiller non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport5_P1_S1
      (&Thermal_system_full_B.OUTPUT_1_0[48]);

    /* S-Function (dsmpb_dataoutport): '<S32>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/p_cond non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport6_P1_S1
      (&Thermal_system_full_B.OUTPUT_1_0[93]);
  }

  /* Sum: '<S317>/SUM' incorporates:
   *  Constant: '<S317>/CONSTANT'
   */
  Thermal_system_full_B.SUM = Thermal_system_full_B.OUTPUT_1_0[100] +
    Thermal_system_full_P.CONSTANT_Value;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S19>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_inverter non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport7_P1_S1(&Thermal_system_full_B.SUM);
  }

  /* Sum: '<S34>/PJoule_battery' */
  Thermal_system_full_B.PJoule_battery = ((Thermal_system_full_B.OUTPUT_1_0[3] +
    Thermal_system_full_B.OUTPUT_1_0[4]) + Thermal_system_full_B.OUTPUT_1_0[5])
    + Thermal_system_full_B.OUTPUT_1_0[6];
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S8>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/PJoule_battery non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport8_P1_S1
      (&Thermal_system_full_B.PJoule_battery);
  }

  /* Sum: '<S111>/SUM' incorporates:
   *  Constant: '<S111>/CONSTANT'
   */
  Thermal_system_full_B.SUM_a = Thermal_system_full_B.OUTPUT_1_0[14] +
    Thermal_system_full_P.CONSTANT_Value_j;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S17>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_coolant_battery_in non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport9_P1_S1(&Thermal_system_full_B.SUM_a);
  }

  /* Sum: '<S325>/SUM' incorporates:
   *  Constant: '<S325>/CONSTANT'
   */
  Thermal_system_full_B.SUM_i = Thermal_system_full_B.OUTPUT_1_0[101] +
    Thermal_system_full_P.CONSTANT_Value_f;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S20>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_motor non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport10_P1_S1
      (&Thermal_system_full_B.SUM_i);
  }

  /* Sum: '<S97>/SUM' incorporates:
   *  Constant: '<S97>/CONSTANT'
   */
  Thermal_system_full_B.SUM_at = Thermal_system_full_B.OUTPUT_1_0[7] +
    Thermal_system_full_P.CONSTANT_Value_c;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S13>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_battery1 non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport11_P1_S1
      (&Thermal_system_full_B.SUM_at);
  }

  /* Sum: '<S99>/SUM' incorporates:
   *  Constant: '<S99>/CONSTANT'
   */
  Thermal_system_full_B.SUM_o = Thermal_system_full_B.OUTPUT_1_0[8] +
    Thermal_system_full_P.CONSTANT_Value_o;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S14>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_battery2 non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport12_P1_S1
      (&Thermal_system_full_B.SUM_o);
  }

  /* Sum: '<S101>/SUM' incorporates:
   *  Constant: '<S101>/CONSTANT'
   */
  Thermal_system_full_B.SUM_h = Thermal_system_full_B.OUTPUT_1_0[9] +
    Thermal_system_full_P.CONSTANT_Value_ck;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S15>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_battery3 non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport13_P1_S1
      (&Thermal_system_full_B.SUM_h);
  }

  /* Sum: '<S103>/SUM' incorporates:
   *  Constant: '<S103>/CONSTANT'
   */
  Thermal_system_full_B.SUM_e = Thermal_system_full_B.OUTPUT_1_0[10] +
    Thermal_system_full_P.CONSTANT_Value_g;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S16>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_battery4 non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport14_P1_S1
      (&Thermal_system_full_B.SUM_e);
  }

  /* Sum: '<S319>/SUM' incorporates:
   *  Constant: '<S319>/CONSTANT'
   */
  Thermal_system_full_B.SUM_it = Thermal_system_full_B.OUTPUT_1_0[99] +
    Thermal_system_full_P.CONSTANT_Value_b;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* S-Function (dsmpb_dataoutport): '<S18>/Data Outport S-Fcn' */

    /* Write access point of block Thermal_system_full/CAN NETWORK/T_coolant_inverter_out non-bus port 1 */
    ap_write_Thermal_system_full_DataOutport15_P1_S1
      (&Thermal_system_full_B.SUM_it);

    /* S-Function (dsmpb_datainport): '<S24>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_comp non-bus port 1 */
    ap_read_Thermal_system_full_DataInport3_P1_S1
      (&Thermal_system_full_B.cmd_comp);

    /* S-Function (dsmpb_datainport): '<S25>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_fan non-bus port 1 */
    ap_read_Thermal_system_full_DataInport4_P1_S1
      (&Thermal_system_full_B.cmd_fanValue);

    /* S-Function (dsmpb_datainport): '<S26>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_heater non-bus port 1 */
    ap_read_Thermal_system_full_DataInport5_P1_S1
      (&Thermal_system_full_B.cmd_heater);

    /* S-Function (dsmpb_datainport): '<S29>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_rad_bypass non-bus port 1 */
    ap_read_Thermal_system_full_DataInport6_P1_S1
      (&Thermal_system_full_B.cmd_rad_bypassValue);

    /* S-Function (dsmpb_datainport): '<S23>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_chiller_bypass non-bus port 1 */
    ap_read_Thermal_system_full_DataInport7_P1_S1
      (&Thermal_system_full_B.cmd_chiller_bypassValue);

    /* S-Function (dsmpb_datainport): '<S22>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_batery_pump non-bus port 1 */
    ap_read_Thermal_system_full_DataInport8_P1_S1
      (&Thermal_system_full_B.cmd_battery_pumpValue);

    /* S-Function (dsmpb_datainport): '<S27>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_motor_pump non-bus port 1 */
    ap_read_Thermal_system_full_DataInport9_P1_S1
      (&Thermal_system_full_B.cmd_motor_pumpValue);

    /* S-Function (dsmpb_datainport): '<S28>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/cmd_parallel_serial non-bus port 1 */
    ap_read_Thermal_system_full_DataInport10_P1_S1
      (&Thermal_system_full_B.cmd_parallel_serialValue);

    /* S-Function (dsmpb_datainport): '<S11>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/Q_inverter non-bus port 1 */
    ap_read_Thermal_system_full_DataInport11_P1_S1
      (&Thermal_system_full_B.Q_inverterValue);

    /* S-Function (dsmpb_datainport): '<S12>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/Q_motor non-bus port 1 */
    ap_read_Thermal_system_full_DataInport12_P1_S1
      (&Thermal_system_full_B.Q_motorValue);

    /* S-Function (dsmpb_datainport): '<S9>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/Q_charger non-bus port 1 */
    ap_read_Thermal_system_full_DataInport13_P1_S1
      (&Thermal_system_full_B.Q_chargerValue);

    /* S-Function (dsmpb_datainport): '<S10>/Data Inport S-Fcn' */

    /* Read access point of block Thermal_system_full/CAN NETWORK/Q_dcdc non-bus port 1 */
    ap_read_Thermal_system_full_DataInport14_P1_S1
      (&Thermal_system_full_B.Q_dcdcValue);
  }

  /* MinMax: '<S3>/T_ battery' */
  maxV = fmax(Thermal_system_full_B.SUM_at, Thermal_system_full_B.SUM_o);
  maxV = fmax(maxV, Thermal_system_full_B.SUM_h);
  maxV = fmax(maxV, Thermal_system_full_B.SUM_e);

  /* MinMax: '<S3>/T_ battery' */
  Thermal_system_full_B.T_battery = maxV;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Sum: '<S34>/Qdot_BMS' */
  Thermal_system_full_B.Qdot_BMS = Thermal_system_full_B.OUTPUT_1_0[18] -
    Thermal_system_full_B.OUTPUT_1_0[12];

  /* Gain: '<S190>/GAIN' */
  Thermal_system_full_B.GAIN = Thermal_system_full_P.GAIN_Gain *
    Thermal_system_full_B.OUTPUT_1_0[47];

  /* Gain: '<S175>/GAIN' */
  Thermal_system_full_B.GAIN_e = Thermal_system_full_P.GAIN_Gain_p *
    Thermal_system_full_B.OUTPUT_1_0[39];

  /* Sum: '<S37>/Subtract4' */
  Thermal_system_full_B.Subtract4 = Thermal_system_full_B.GAIN -
    Thermal_system_full_B.GAIN_e;

  /* Gain: '<S251>/GAIN' */
  Thermal_system_full_B.GAIN_f = Thermal_system_full_P.GAIN_Gain_n *
    Thermal_system_full_B.OUTPUT_1_0[73];

  /* Gain: '<S259>/GAIN' */
  Thermal_system_full_B.GAIN_l = Thermal_system_full_P.GAIN_Gain_i *
    Thermal_system_full_B.OUTPUT_1_0[77];

  /* Sum: '<S39>/Subtract' */
  Thermal_system_full_B.Wdot = Thermal_system_full_B.GAIN_f -
    Thermal_system_full_B.GAIN_l;

  /* Saturate: '<S35>/Saturation' */
  maxV = Thermal_system_full_B.Wdot;
  u1 = Thermal_system_full_P.Saturation_LowerSat;
  u2 = Thermal_system_full_P.Saturation_UpperSat;
  if (maxV > u2) {
    /* Saturate: '<S35>/Saturation' */
    Thermal_system_full_B.Saturation = u2;
  } else if (maxV < u1) {
    /* Saturate: '<S35>/Saturation' */
    Thermal_system_full_B.Saturation = u1;
  } else {
    /* Saturate: '<S35>/Saturation' */
    Thermal_system_full_B.Saturation = maxV;
  }

  /* End of Saturate: '<S35>/Saturation' */

  /* Product: '<S35>/Divide' */
  Thermal_system_full_B.Divide = Thermal_system_full_B.Subtract4 /
    Thermal_system_full_B.Saturation;

  /* Saturate: '<S35>/Saturation1' */
  maxV = Thermal_system_full_B.Wdot;
  u1 = Thermal_system_full_P.Saturation1_LowerSat;
  u2 = Thermal_system_full_P.Saturation1_UpperSat;
  if (maxV > u2) {
    /* Saturate: '<S35>/Saturation1' */
    Thermal_system_full_B.Saturation1 = u2;
  } else if (maxV < u1) {
    /* Saturate: '<S35>/Saturation1' */
    Thermal_system_full_B.Saturation1 = u1;
  } else {
    /* Saturate: '<S35>/Saturation1' */
    Thermal_system_full_B.Saturation1 = maxV;
  }

  /* End of Saturate: '<S35>/Saturation1' */

  /* Product: '<S35>/Divide1' */
  Thermal_system_full_B.Divide1 = Thermal_system_full_B.Qdot_BMS /
    Thermal_system_full_B.Saturation1;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Gain: '<S153>/GAIN' */
  Thermal_system_full_B.GAIN_lh = Thermal_system_full_P.GAIN_Gain_e *
    Thermal_system_full_B.OUTPUT_1_0[32];

  /* Product: '<S140>/Divide' */
  Thermal_system_full_B.Divide_o = Thermal_system_full_B.OUTPUT_1_0[29] /
    Thermal_system_full_B.OUTPUT_1_0[31];

  /* Sum: '<S140>/Add' */
  Thermal_system_full_B.Add_h = Thermal_system_full_B.GAIN_lh +
    Thermal_system_full_B.Divide_o;

  /* Gain: '<S165>/GAIN' */
  Thermal_system_full_B.GAIN_n = Thermal_system_full_P.GAIN_Gain_b *
    Thermal_system_full_B.OUTPUT_1_0[38];

  /* Product: '<S141>/Divide' */
  Thermal_system_full_B.Divide_j = Thermal_system_full_B.OUTPUT_1_0[35] /
    Thermal_system_full_B.OUTPUT_1_0[37];

  /* Sum: '<S141>/Add' */
  Thermal_system_full_B.Add_c = Thermal_system_full_B.GAIN_n +
    Thermal_system_full_B.Divide_j;

  /* Sum: '<S37>/Subtract3' */
  Thermal_system_full_B.Subtract3 = Thermal_system_full_B.Add_h -
    Thermal_system_full_B.Add_c;

  /* Product: '<S37>/Product2' */
  Thermal_system_full_B.Product2 = Thermal_system_full_B.Subtract3 *
    Thermal_system_full_B.OUTPUT_1_0[33];
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Gain: '<S252>/GAIN' */
  Thermal_system_full_B.GAIN_d = Thermal_system_full_P.GAIN_Gain_l *
    Thermal_system_full_B.OUTPUT_1_0[75];

  /* Gain: '<S260>/GAIN' */
  Thermal_system_full_B.GAIN_er = Thermal_system_full_P.GAIN_Gain_h *
    Thermal_system_full_B.OUTPUT_1_0[79];

  /* Sum: '<S39>/Subtract1' */
  Thermal_system_full_B.Subtract1 = Thermal_system_full_B.GAIN_d -
    Thermal_system_full_B.GAIN_er;

  /* Product: '<S39>/Product' */
  Thermal_system_full_B.Wdot_fromh = Thermal_system_full_B.OUTPUT_1_0[80] *
    Thermal_system_full_B.Subtract1;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Integrator: '<S40>/Integrator' */
  Thermal_system_full_B.Integrator = Thermal_system_full_X.Integrator_CSTATE;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* Gain: '<S40>/Gain' */
    Thermal_system_full_B.Gain_c = Thermal_system_full_P.Gain_Gain_b *
      Thermal_system_full_B.v_vehicleValue;
  }

  /* Integrator: '<S41>/Integrator' */
  Thermal_system_full_B.Energy_battery =
    Thermal_system_full_X.Integrator_CSTATE_h;

  /* Integrator: '<S41>/Integrator1' */
  Thermal_system_full_B.Energy_BTM = Thermal_system_full_X.Integrator1_CSTATE;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Gain: '<S45>/Gain' */
  Thermal_system_full_B.Gain_cw = Thermal_system_full_P.Gain_Gain_p *
    Thermal_system_full_B.MaxSpeedrpm;

  /* Product: '<S43>/MeccPower_MotorPump' */
  Thermal_system_full_B.MeccPower_MotorPump = Thermal_system_full_B.Gain_cw *
    Thermal_system_full_B.OUTPUT_1_0[24];

  /* Gain: '<S43>/EPower_BatteryPump' */
  Thermal_system_full_B.EPower_BatteryPump =
    Thermal_system_full_P.EPower_BatteryPump_Gain *
    Thermal_system_full_B.MeccPower_MotorPump;

  /* Gain: '<S56>/Gain' */
  Thermal_system_full_B.Gain_k = Thermal_system_full_P.Gain_Gain_do *
    Thermal_system_full_B.MaxSpeedrpm_d;

  /* Product: '<S43>/MeccPower_MotorPump1' */
  Thermal_system_full_B.MeccPower_MotorPump1 = Thermal_system_full_B.Gain_k *
    Thermal_system_full_B.OUTPUT_1_0[102];

  /* Gain: '<S43>/EPower_MotorPump' */
  Thermal_system_full_B.EPower_MotorPump =
    Thermal_system_full_P.EPower_MotorPump_Gain *
    Thermal_system_full_B.MeccPower_MotorPump1;

  /* Sum: '<S41>/Add' incorporates:
   *  Constant: '<S43>/Constant'
   */
  Thermal_system_full_B.EPower_BTM = ((Thermal_system_full_B.EPower_Compressor +
    Thermal_system_full_P.Constant_Value_m) +
    Thermal_system_full_B.EPower_BatteryPump) +
    Thermal_system_full_B.EPower_MotorPump;

  /* Product: '<S41>/Product1' */
  Thermal_system_full_B.EPower_battery = Thermal_system_full_B.OUTPUT_1_0[23] *
    Thermal_system_full_B.i_battery;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Integrator: '<S43>/Integrator2' */
  Thermal_system_full_B.Integrator2 = Thermal_system_full_X.Integrator2_CSTATE;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Integrator: '<S43>/Integrator' */
  Thermal_system_full_B.Integrator_n = Thermal_system_full_X.Integrator_CSTATE_d;

  /* TransferFcn: '<S53>/Transfer Fcn' */
  Thermal_system_full_B.TransferFcn_g = 0.0;
  Thermal_system_full_B.TransferFcn_g += Thermal_system_full_P.TransferFcn_C_o *
    Thermal_system_full_X.TransferFcn_CSTATE_b;

  /* Gain: '<S53>/Max Power [W]' */
  Thermal_system_full_B.MaxPowerW = Thermal_system_full_P.MaxPowerW_Gain *
    Thermal_system_full_B.TransferFcn_g;

  /* Sum: '<S44>/EPower_BMS' incorporates:
   *  Constant: '<S43>/Constant'
   */
  Thermal_system_full_B.EPower_BMS = (((Thermal_system_full_B.EPower_MotorPump +
    Thermal_system_full_B.EPower_BatteryPump) +
    Thermal_system_full_B.EPower_Compressor) +
    Thermal_system_full_P.Constant_Value_m) + Thermal_system_full_B.MaxPowerW;

  /* Product: '<S44>/iBMScomputation' */
  Thermal_system_full_B.iBMScomputation = Thermal_system_full_B.EPower_BMS /
    Thermal_system_full_B.OUTPUT_1_0[23];

  /* Sum: '<S74>/Plus' incorporates:
   *  Constant: '<S74>/Constant'
   */
  Thermal_system_full_B.Plus = Thermal_system_full_B.OUTPUT_1_0[2] +
    Thermal_system_full_P.Constant_Value_o;

  /* Product: '<S74>/Divide' */
  Thermal_system_full_B.Divide_b = Thermal_system_full_B.OUTPUT_1_0[1] /
    Thermal_system_full_B.Plus;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Gain: '<S112>/GAIN' */
  Thermal_system_full_B.GAIN_l3 = Thermal_system_full_P.GAIN_Gain_a *
    Thermal_system_full_B.OUTPUT_1_0[13];

  /* Sum: '<S123>/SUM' incorporates:
   *  Constant: '<S123>/CONSTANT'
   */
  Thermal_system_full_B.SUM_c = Thermal_system_full_B.OUTPUT_1_0[20] +
    Thermal_system_full_P.CONSTANT_Value_n;

  /* Gain: '<S124>/GAIN' */
  Thermal_system_full_B.GAIN_c = Thermal_system_full_P.GAIN_Gain_o *
    Thermal_system_full_B.OUTPUT_1_0[19];

  /* Gain: '<S176>/GAIN' */
  Thermal_system_full_B.GAIN_nl = Thermal_system_full_P.GAIN_Gain_h5 *
    Thermal_system_full_B.OUTPUT_1_0[42];

  /* Gain: '<S194>/GAIN' */
  Thermal_system_full_B.GAIN_erl = Thermal_system_full_P.GAIN_Gain_id *
    Thermal_system_full_B.OUTPUT_1_0[50];

  /* Gain: '<S210>/GAIN' */
  Thermal_system_full_B.GAIN_e4 = Thermal_system_full_P.GAIN_Gain_j *
    Thermal_system_full_B.OUTPUT_1_0[56];

  /* Gain: '<S222>/GAIN' */
  Thermal_system_full_B.GAIN_o = Thermal_system_full_P.GAIN_Gain_d *
    Thermal_system_full_B.OUTPUT_1_0[62];

  /* Gain: '<S234>/GAIN' */
  Thermal_system_full_B.GAIN_du = Thermal_system_full_P.GAIN_Gain_im *
    Thermal_system_full_B.OUTPUT_1_0[68];
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
  }

  /* Gain: '<S245>/GAIN' */
  Thermal_system_full_B.GAIN_h = Thermal_system_full_P.GAIN_Gain_ol *
    Thermal_system_full_B.OUTPUT_1_0[81];

  /* Product: '<S50>/Divide' */
  Thermal_system_full_B.Divide_bu = Thermal_system_full_B.GAIN_h /
    Thermal_system_full_B.Add;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* Gain: '<S50>/Gain' */
    Thermal_system_full_B.Gain_d = Thermal_system_full_P.Gain_Gain_n *
      Thermal_system_full_B.cmd_comp;

    /* Saturate: '<S50>/Saturation' */
    maxV = Thermal_system_full_B.Gain_d;
    u1 = Thermal_system_full_P.Saturation_LowerSat_e;
    u2 = Thermal_system_full_P.Saturation_UpperSat_n;
    if (maxV > u2) {
      /* Saturate: '<S50>/Saturation' */
      Thermal_system_full_B.Saturation_g = u2;
    } else if (maxV < u1) {
      /* Saturate: '<S50>/Saturation' */
      Thermal_system_full_B.Saturation_g = u1;
    } else {
      /* Saturate: '<S50>/Saturation' */
      Thermal_system_full_B.Saturation_g = maxV;
    }

    /* End of Saturate: '<S50>/Saturation' */
  }

  /* Gain: '<S51>/Gain1' */
  Thermal_system_full_B.Gain1_f = Thermal_system_full_P.Gain1_Gain_c *
    Thermal_system_full_B.Gain_a;

  /* Gain: '<S281>/GAIN' */
  Thermal_system_full_B.GAIN_i = Thermal_system_full_P.GAIN_Gain_j2 *
    Thermal_system_full_B.OUTPUT_1_0[84];

  /* Gain: '<S282>/GAIN' */
  Thermal_system_full_B.GAIN_p = Thermal_system_full_P.GAIN_Gain_lo *
    Thermal_system_full_B.OUTPUT_1_0[87];

  /* Gain: '<S297>/GAIN' */
  Thermal_system_full_B.GAIN_k = Thermal_system_full_P.GAIN_Gain_f *
    Thermal_system_full_B.OUTPUT_1_0[92];

  /* Gain: '<S303>/GAIN' */
  Thermal_system_full_B.GAIN_kf = Thermal_system_full_P.GAIN_Gain_ef *
    Thermal_system_full_B.OUTPUT_1_0[95];

  /* SimscapeInputBlock: '<S354>/INPUT_11_1_1' */
  Thermal_system_full_B.INPUT_11_1_1[0] = Thermal_system_full_B.Q_dcdcValue;
  Thermal_system_full_B.INPUT_11_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_11_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_11_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_11_1_1[0] ==
        Thermal_system_full_DW.INPUT_11_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_11_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_11_1_1[0];
  }

  Thermal_system_full_B.INPUT_11_1_1[0] =
    Thermal_system_full_DW.INPUT_11_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_11_1_1[3] =
    Thermal_system_full_DW.INPUT_11_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_11_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_12_1_1' */
  Thermal_system_full_B.INPUT_12_1_1[0] = Thermal_system_full_B.MaxPowerW;
  Thermal_system_full_B.INPUT_12_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_12_1_1[2] = 0.0;
  Thermal_system_full_B.INPUT_12_1_1[3] = 0.0;

  /* SimscapeInputBlock: '<S354>/INPUT_13_1_1' */
  Thermal_system_full_B.INPUT_13_1_1[0] = Thermal_system_full_B.Q_inverterValue;
  Thermal_system_full_B.INPUT_13_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_13_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_13_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_13_1_1[0] ==
        Thermal_system_full_DW.INPUT_13_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_13_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_13_1_1[0];
  }

  Thermal_system_full_B.INPUT_13_1_1[0] =
    Thermal_system_full_DW.INPUT_13_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_13_1_1[3] =
    Thermal_system_full_DW.INPUT_13_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_13_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_14_1_1' */
  Thermal_system_full_B.INPUT_14_1_1[0] = Thermal_system_full_B.Q_motorValue;
  Thermal_system_full_B.INPUT_14_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_14_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_14_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_14_1_1[0] ==
        Thermal_system_full_DW.INPUT_14_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_14_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_14_1_1[0];
  }

  Thermal_system_full_B.INPUT_14_1_1[0] =
    Thermal_system_full_DW.INPUT_14_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_14_1_1[3] =
    Thermal_system_full_DW.INPUT_14_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_14_1_1' */

  /* SimscapeInputBlock: '<S354>/INPUT_3_1_1' */
  Thermal_system_full_B.INPUT_3_1_1[0] = Thermal_system_full_B.Q_chargerValue;
  Thermal_system_full_B.INPUT_3_1_1[1] = 0.0;
  Thermal_system_full_B.INPUT_3_1_1[2] = 0.0;
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    Thermal_system_full_DW.INPUT_3_1_1_Discrete[0] =
      !(Thermal_system_full_B.INPUT_3_1_1[0] ==
        Thermal_system_full_DW.INPUT_3_1_1_Discrete[1]);
    Thermal_system_full_DW.INPUT_3_1_1_Discrete[1] =
      Thermal_system_full_B.INPUT_3_1_1[0];
  }

  Thermal_system_full_B.INPUT_3_1_1[0] =
    Thermal_system_full_DW.INPUT_3_1_1_Discrete[1];
  Thermal_system_full_B.INPUT_3_1_1[3] =
    Thermal_system_full_DW.INPUT_3_1_1_Discrete[0];

  /* End of SimscapeInputBlock: '<S354>/INPUT_3_1_1' */
  /* user code (Output function Trailer) */
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    /* Function module access point of system <Root>    */
    ap_exit_Thermal_system_full_SIDRoot_TID1();
  }
}

/* Model update function */
void Thermal_system_full_update(void)
{
  NeslSimulationData *simulationData;
  NeslSimulator *simulator;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  int32_T tmp_2;
  int_T tmp_1[25];
  boolean_T tmp;

  /* Update for SimscapeExecutionBlock: '<S354>/STATE_1' */
  simulationData = (NeslSimulationData *)Thermal_system_full_DW.STATE_1_SimData;
  time = Thermal_system_full_M->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 626;
  simulationData->mData->mContStates.mX =
    &Thermal_system_full_X.Thermal_system_fullThermal_Syst[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX =
    &Thermal_system_full_DW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 394;
  simulationData->mData->mModeVector.mX = &Thermal_system_full_DW.STATE_1_Modes
    [0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep
    (Thermal_system_full_M);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&Thermal_system_full_M->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = Thermal_system_full_B.INPUT_1_1_1[0];
  tmp_0[1] = Thermal_system_full_B.INPUT_1_1_1[1];
  tmp_0[2] = Thermal_system_full_B.INPUT_1_1_1[2];
  tmp_0[3] = Thermal_system_full_B.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = Thermal_system_full_B.INPUT_2_1_1[0];
  tmp_0[5] = Thermal_system_full_B.INPUT_2_1_1[1];
  tmp_0[6] = Thermal_system_full_B.INPUT_2_1_1[2];
  tmp_0[7] = Thermal_system_full_B.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = Thermal_system_full_B.INPUT_3_1_1[0];
  tmp_0[9] = Thermal_system_full_B.INPUT_3_1_1[1];
  tmp_0[10] = Thermal_system_full_B.INPUT_3_1_1[2];
  tmp_0[11] = Thermal_system_full_B.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = Thermal_system_full_B.INPUT_4_1_1[0];
  tmp_0[13] = Thermal_system_full_B.INPUT_4_1_1[1];
  tmp_0[14] = Thermal_system_full_B.INPUT_4_1_1[2];
  tmp_0[15] = Thermal_system_full_B.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = Thermal_system_full_B.INPUT_5_1_1[0];
  tmp_0[17] = Thermal_system_full_B.INPUT_5_1_1[1];
  tmp_0[18] = Thermal_system_full_B.INPUT_5_1_1[2];
  tmp_0[19] = Thermal_system_full_B.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = Thermal_system_full_B.INPUT_10_1_1[0];
  tmp_0[21] = Thermal_system_full_B.INPUT_10_1_1[1];
  tmp_0[22] = Thermal_system_full_B.INPUT_10_1_1[2];
  tmp_0[23] = Thermal_system_full_B.INPUT_10_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = Thermal_system_full_B.INPUT_8_1_1[0];
  tmp_0[25] = Thermal_system_full_B.INPUT_8_1_1[1];
  tmp_0[26] = Thermal_system_full_B.INPUT_8_1_1[2];
  tmp_0[27] = Thermal_system_full_B.INPUT_8_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = Thermal_system_full_B.INPUT_7_1_1[0];
  tmp_0[29] = Thermal_system_full_B.INPUT_7_1_1[1];
  tmp_0[30] = Thermal_system_full_B.INPUT_7_1_1[2];
  tmp_0[31] = Thermal_system_full_B.INPUT_7_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = Thermal_system_full_B.INPUT_9_1_1[0];
  tmp_0[33] = Thermal_system_full_B.INPUT_9_1_1[1];
  tmp_0[34] = Thermal_system_full_B.INPUT_9_1_1[2];
  tmp_0[35] = Thermal_system_full_B.INPUT_9_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = Thermal_system_full_B.INPUT_6_1_1[0];
  tmp_0[37] = Thermal_system_full_B.INPUT_6_1_1[1];
  tmp_0[38] = Thermal_system_full_B.INPUT_6_1_1[2];
  tmp_0[39] = Thermal_system_full_B.INPUT_6_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = Thermal_system_full_B.INPUT_11_1_1[0];
  tmp_0[41] = Thermal_system_full_B.INPUT_11_1_1[1];
  tmp_0[42] = Thermal_system_full_B.INPUT_11_1_1[2];
  tmp_0[43] = Thermal_system_full_B.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = Thermal_system_full_B.INPUT_12_1_1[0];
  tmp_0[45] = Thermal_system_full_B.INPUT_12_1_1[1];
  tmp_0[46] = Thermal_system_full_B.INPUT_12_1_1[2];
  tmp_0[47] = Thermal_system_full_B.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = Thermal_system_full_B.INPUT_13_1_1[0];
  tmp_0[49] = Thermal_system_full_B.INPUT_13_1_1[1];
  tmp_0[50] = Thermal_system_full_B.INPUT_13_1_1[2];
  tmp_0[51] = Thermal_system_full_B.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = Thermal_system_full_B.INPUT_14_1_1[0];
  tmp_0[53] = Thermal_system_full_B.INPUT_14_1_1[1];
  tmp_0[54] = Thermal_system_full_B.INPUT_14_1_1[2];
  tmp_0[55] = Thermal_system_full_B.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = Thermal_system_full_B.INPUT_15_1_1[0];
  tmp_0[57] = Thermal_system_full_B.INPUT_15_1_1[1];
  tmp_0[58] = Thermal_system_full_B.INPUT_15_1_1[2];
  tmp_0[59] = Thermal_system_full_B.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = Thermal_system_full_B.INPUT_16_1_1[0];
  tmp_0[61] = Thermal_system_full_B.INPUT_16_1_1[1];
  tmp_0[62] = Thermal_system_full_B.INPUT_16_1_1[2];
  tmp_0[63] = Thermal_system_full_B.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = Thermal_system_full_B.INPUT_17_1_1[0];
  tmp_0[65] = Thermal_system_full_B.INPUT_17_1_1[1];
  tmp_0[66] = Thermal_system_full_B.INPUT_17_1_1[2];
  tmp_0[67] = Thermal_system_full_B.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = Thermal_system_full_B.INPUT_18_1_1[0];
  tmp_0[69] = Thermal_system_full_B.INPUT_18_1_1[1];
  tmp_0[70] = Thermal_system_full_B.INPUT_18_1_1[2];
  tmp_0[71] = Thermal_system_full_B.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = Thermal_system_full_B.INPUT_22_1_1[0];
  tmp_0[73] = Thermal_system_full_B.INPUT_22_1_1[1];
  tmp_0[74] = Thermal_system_full_B.INPUT_22_1_1[2];
  tmp_0[75] = Thermal_system_full_B.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = Thermal_system_full_B.INPUT_20_1_1[0];
  tmp_0[77] = Thermal_system_full_B.INPUT_20_1_1[1];
  tmp_0[78] = Thermal_system_full_B.INPUT_20_1_1[2];
  tmp_0[79] = Thermal_system_full_B.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = Thermal_system_full_B.INPUT_19_1_1[0];
  tmp_0[81] = Thermal_system_full_B.INPUT_19_1_1[1];
  tmp_0[82] = Thermal_system_full_B.INPUT_19_1_1[2];
  tmp_0[83] = Thermal_system_full_B.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = Thermal_system_full_B.INPUT_21_1_1[0];
  tmp_0[85] = Thermal_system_full_B.INPUT_21_1_1[1];
  tmp_0[86] = Thermal_system_full_B.INPUT_21_1_1[2];
  tmp_0[87] = Thermal_system_full_B.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = Thermal_system_full_B.INPUT_23_1_1[0];
  tmp_0[89] = Thermal_system_full_B.INPUT_23_1_1[1];
  tmp_0[90] = Thermal_system_full_B.INPUT_23_1_1[2];
  tmp_0[91] = Thermal_system_full_B.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = Thermal_system_full_B.INPUT_24_1_1[0];
  tmp_0[93] = Thermal_system_full_B.INPUT_24_1_1[1];
  tmp_0[94] = Thermal_system_full_B.INPUT_24_1_1[2];
  tmp_0[95] = Thermal_system_full_B.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  simulator = (NeslSimulator *)Thermal_system_full_DW.STATE_1_Simulator;
  diagnosticManager = (NeuDiagnosticManager *)
    Thermal_system_full_DW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  tmp_2 = ne_simulator_method(simulator, NESL_SIM_UPDATE, simulationData,
    diagnosticManager);
  if (tmp_2 != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(Thermal_system_full_M, msg);
    }
  }

  /* End of Update for SimscapeExecutionBlock: '<S354>/STATE_1' */
  if (rtmIsMajorTimeStep(Thermal_system_full_M)) {
    rt_ertODEUpdateContinuousStates(&Thermal_system_full_M->solverInfo);
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++Thermal_system_full_M->Timing.clockTick0)) {
    ++Thermal_system_full_M->Timing.clockTickH0;
  }

  Thermal_system_full_M->Timing.t[0] = rtsiGetSolverStopTime
    (&Thermal_system_full_M->solverInfo);

  {
    /* Update absolute timer for sample time: [0.2s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The resolution of this integer timer is 0.2, which is the step size
     * of the task. Size of "clockTick1" ensures timer will not overflow during the
     * application lifespan selected.
     * Timer of this task consists of two 32 bit unsigned integers.
     * The two integers represent the low bits Timing.clockTick1 and the high bits
     * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
     */
    Thermal_system_full_M->Timing.clockTick1++;
    if (!Thermal_system_full_M->Timing.clockTick1) {
      Thermal_system_full_M->Timing.clockTickH1++;
    }
  }
}

/* Derivatives for root system: '<Root>' */
void Thermal_system_full_derivatives(void)
{
  NeslSimulationData *simulationData;
  NeslSimulator *simulator;
  NeuDiagnosticManager *diagnosticManager;
  NeuDiagnosticTree *diagnosticTree;
  XDot_Thermal_system_full_T *_rtXdot;
  char *msg;
  real_T tmp_0[96];
  real_T time;
  int_T tmp_1[25];
  int_T is;
  boolean_T tmp;
  _rtXdot = ((XDot_Thermal_system_full_T *) Thermal_system_full_M->derivs);

  /* Derivatives for TransferFcn: '<S50>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE = 0.0;
  _rtXdot->TransferFcn_CSTATE += Thermal_system_full_P.TransferFcn_A *
    Thermal_system_full_X.TransferFcn_CSTATE;
  _rtXdot->TransferFcn_CSTATE += Thermal_system_full_B.Saturation_g;

  /* Derivatives for TransferFcn: '<S50>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE = 0.0;
  _rtXdot->TransferFcn1_CSTATE += Thermal_system_full_P.TransferFcn1_A *
    Thermal_system_full_X.TransferFcn1_CSTATE;
  _rtXdot->TransferFcn1_CSTATE += Thermal_system_full_B.Divide_bu;

  /* Derivatives for TransferFcn: '<S44>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_a = 0.0;
  _rtXdot->TransferFcn_CSTATE_a += Thermal_system_full_P.TransferFcn_A_l *
    Thermal_system_full_X.TransferFcn_CSTATE_a;
  _rtXdot->TransferFcn_CSTATE_a += Thermal_system_full_B.iBMScomputation;

  /* Derivatives for TransferFcn: '<S45>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_n = 0.0;
  _rtXdot->TransferFcn_CSTATE_n += Thermal_system_full_P.TransferFcn_A_j *
    Thermal_system_full_X.TransferFcn_CSTATE_n;
  _rtXdot->TransferFcn_CSTATE_n += Thermal_system_full_B.cmd_battery_pumpValue;

  /* Derivatives for TransferFcn: '<S48>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_k = 0.0;
  _rtXdot->TransferFcn_CSTATE_k += Thermal_system_full_P.TransferFcn_A_m *
    Thermal_system_full_X.TransferFcn_CSTATE_k;
  _rtXdot->TransferFcn_CSTATE_k += Thermal_system_full_B.cmd_chiller_bypassValue;

  /* Derivatives for TransferFcn: '<S51>/Transfer Fcn1' */
  _rtXdot->TransferFcn1_CSTATE_d = 0.0;
  _rtXdot->TransferFcn1_CSTATE_d += Thermal_system_full_P.TransferFcn1_A_a *
    Thermal_system_full_X.TransferFcn1_CSTATE_d;
  _rtXdot->TransferFcn1_CSTATE_d += Thermal_system_full_B.cmd_fanValue;

  /* Derivatives for TransferFcn: '<S56>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_nn = 0.0;
  _rtXdot->TransferFcn_CSTATE_nn += Thermal_system_full_P.TransferFcn_A_jp *
    Thermal_system_full_X.TransferFcn_CSTATE_nn;
  _rtXdot->TransferFcn_CSTATE_nn += Thermal_system_full_B.cmd_motor_pumpValue;

  /* Derivatives for TransferFcn: '<S57>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_kv = 0.0;
  _rtXdot->TransferFcn_CSTATE_kv += Thermal_system_full_P.TransferFcn_A_g *
    Thermal_system_full_X.TransferFcn_CSTATE_kv;
  _rtXdot->TransferFcn_CSTATE_kv +=
    Thermal_system_full_B.cmd_parallel_serialValue;

  /* Derivatives for TransferFcn: '<S59>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_e = 0.0;
  _rtXdot->TransferFcn_CSTATE_e += Thermal_system_full_P.TransferFcn_A_n *
    Thermal_system_full_X.TransferFcn_CSTATE_e;
  _rtXdot->TransferFcn_CSTATE_e += Thermal_system_full_B.cmd_rad_bypassValue;

  /* Derivatives for SimscapeExecutionBlock: '<S354>/STATE_1' */
  simulationData = (NeslSimulationData *)Thermal_system_full_DW.STATE_1_SimData;
  time = Thermal_system_full_M->Timing.t[0];
  simulationData->mData->mTime.mN = 1;
  simulationData->mData->mTime.mX = &time;
  simulationData->mData->mContStates.mN = 626;
  simulationData->mData->mContStates.mX =
    &Thermal_system_full_X.Thermal_system_fullThermal_Syst[0];
  simulationData->mData->mDiscStates.mN = 0;
  simulationData->mData->mDiscStates.mX =
    &Thermal_system_full_DW.STATE_1_Discrete;
  simulationData->mData->mModeVector.mN = 394;
  simulationData->mData->mModeVector.mX = &Thermal_system_full_DW.STATE_1_Modes
    [0];
  tmp = false;
  simulationData->mData->mFoundZcEvents = tmp;
  simulationData->mData->mIsMajorTimeStep = rtmIsMajorTimeStep
    (Thermal_system_full_M);
  tmp = false;
  simulationData->mData->mIsSolverAssertCheck = tmp;
  simulationData->mData->mIsSolverCheckingCIC = false;
  tmp = rtsiIsSolverComputingJacobian(&Thermal_system_full_M->solverInfo);
  simulationData->mData->mIsComputingJacobian = tmp;
  simulationData->mData->mIsEvaluatingF0 = false;
  simulationData->mData->mIsSolverRequestingReset = false;
  tmp_1[0] = 0;
  tmp_0[0] = Thermal_system_full_B.INPUT_1_1_1[0];
  tmp_0[1] = Thermal_system_full_B.INPUT_1_1_1[1];
  tmp_0[2] = Thermal_system_full_B.INPUT_1_1_1[2];
  tmp_0[3] = Thermal_system_full_B.INPUT_1_1_1[3];
  tmp_1[1] = 4;
  tmp_0[4] = Thermal_system_full_B.INPUT_2_1_1[0];
  tmp_0[5] = Thermal_system_full_B.INPUT_2_1_1[1];
  tmp_0[6] = Thermal_system_full_B.INPUT_2_1_1[2];
  tmp_0[7] = Thermal_system_full_B.INPUT_2_1_1[3];
  tmp_1[2] = 8;
  tmp_0[8] = Thermal_system_full_B.INPUT_3_1_1[0];
  tmp_0[9] = Thermal_system_full_B.INPUT_3_1_1[1];
  tmp_0[10] = Thermal_system_full_B.INPUT_3_1_1[2];
  tmp_0[11] = Thermal_system_full_B.INPUT_3_1_1[3];
  tmp_1[3] = 12;
  tmp_0[12] = Thermal_system_full_B.INPUT_4_1_1[0];
  tmp_0[13] = Thermal_system_full_B.INPUT_4_1_1[1];
  tmp_0[14] = Thermal_system_full_B.INPUT_4_1_1[2];
  tmp_0[15] = Thermal_system_full_B.INPUT_4_1_1[3];
  tmp_1[4] = 16;
  tmp_0[16] = Thermal_system_full_B.INPUT_5_1_1[0];
  tmp_0[17] = Thermal_system_full_B.INPUT_5_1_1[1];
  tmp_0[18] = Thermal_system_full_B.INPUT_5_1_1[2];
  tmp_0[19] = Thermal_system_full_B.INPUT_5_1_1[3];
  tmp_1[5] = 20;
  tmp_0[20] = Thermal_system_full_B.INPUT_10_1_1[0];
  tmp_0[21] = Thermal_system_full_B.INPUT_10_1_1[1];
  tmp_0[22] = Thermal_system_full_B.INPUT_10_1_1[2];
  tmp_0[23] = Thermal_system_full_B.INPUT_10_1_1[3];
  tmp_1[6] = 24;
  tmp_0[24] = Thermal_system_full_B.INPUT_8_1_1[0];
  tmp_0[25] = Thermal_system_full_B.INPUT_8_1_1[1];
  tmp_0[26] = Thermal_system_full_B.INPUT_8_1_1[2];
  tmp_0[27] = Thermal_system_full_B.INPUT_8_1_1[3];
  tmp_1[7] = 28;
  tmp_0[28] = Thermal_system_full_B.INPUT_7_1_1[0];
  tmp_0[29] = Thermal_system_full_B.INPUT_7_1_1[1];
  tmp_0[30] = Thermal_system_full_B.INPUT_7_1_1[2];
  tmp_0[31] = Thermal_system_full_B.INPUT_7_1_1[3];
  tmp_1[8] = 32;
  tmp_0[32] = Thermal_system_full_B.INPUT_9_1_1[0];
  tmp_0[33] = Thermal_system_full_B.INPUT_9_1_1[1];
  tmp_0[34] = Thermal_system_full_B.INPUT_9_1_1[2];
  tmp_0[35] = Thermal_system_full_B.INPUT_9_1_1[3];
  tmp_1[9] = 36;
  tmp_0[36] = Thermal_system_full_B.INPUT_6_1_1[0];
  tmp_0[37] = Thermal_system_full_B.INPUT_6_1_1[1];
  tmp_0[38] = Thermal_system_full_B.INPUT_6_1_1[2];
  tmp_0[39] = Thermal_system_full_B.INPUT_6_1_1[3];
  tmp_1[10] = 40;
  tmp_0[40] = Thermal_system_full_B.INPUT_11_1_1[0];
  tmp_0[41] = Thermal_system_full_B.INPUT_11_1_1[1];
  tmp_0[42] = Thermal_system_full_B.INPUT_11_1_1[2];
  tmp_0[43] = Thermal_system_full_B.INPUT_11_1_1[3];
  tmp_1[11] = 44;
  tmp_0[44] = Thermal_system_full_B.INPUT_12_1_1[0];
  tmp_0[45] = Thermal_system_full_B.INPUT_12_1_1[1];
  tmp_0[46] = Thermal_system_full_B.INPUT_12_1_1[2];
  tmp_0[47] = Thermal_system_full_B.INPUT_12_1_1[3];
  tmp_1[12] = 48;
  tmp_0[48] = Thermal_system_full_B.INPUT_13_1_1[0];
  tmp_0[49] = Thermal_system_full_B.INPUT_13_1_1[1];
  tmp_0[50] = Thermal_system_full_B.INPUT_13_1_1[2];
  tmp_0[51] = Thermal_system_full_B.INPUT_13_1_1[3];
  tmp_1[13] = 52;
  tmp_0[52] = Thermal_system_full_B.INPUT_14_1_1[0];
  tmp_0[53] = Thermal_system_full_B.INPUT_14_1_1[1];
  tmp_0[54] = Thermal_system_full_B.INPUT_14_1_1[2];
  tmp_0[55] = Thermal_system_full_B.INPUT_14_1_1[3];
  tmp_1[14] = 56;
  tmp_0[56] = Thermal_system_full_B.INPUT_15_1_1[0];
  tmp_0[57] = Thermal_system_full_B.INPUT_15_1_1[1];
  tmp_0[58] = Thermal_system_full_B.INPUT_15_1_1[2];
  tmp_0[59] = Thermal_system_full_B.INPUT_15_1_1[3];
  tmp_1[15] = 60;
  tmp_0[60] = Thermal_system_full_B.INPUT_16_1_1[0];
  tmp_0[61] = Thermal_system_full_B.INPUT_16_1_1[1];
  tmp_0[62] = Thermal_system_full_B.INPUT_16_1_1[2];
  tmp_0[63] = Thermal_system_full_B.INPUT_16_1_1[3];
  tmp_1[16] = 64;
  tmp_0[64] = Thermal_system_full_B.INPUT_17_1_1[0];
  tmp_0[65] = Thermal_system_full_B.INPUT_17_1_1[1];
  tmp_0[66] = Thermal_system_full_B.INPUT_17_1_1[2];
  tmp_0[67] = Thermal_system_full_B.INPUT_17_1_1[3];
  tmp_1[17] = 68;
  tmp_0[68] = Thermal_system_full_B.INPUT_18_1_1[0];
  tmp_0[69] = Thermal_system_full_B.INPUT_18_1_1[1];
  tmp_0[70] = Thermal_system_full_B.INPUT_18_1_1[2];
  tmp_0[71] = Thermal_system_full_B.INPUT_18_1_1[3];
  tmp_1[18] = 72;
  tmp_0[72] = Thermal_system_full_B.INPUT_22_1_1[0];
  tmp_0[73] = Thermal_system_full_B.INPUT_22_1_1[1];
  tmp_0[74] = Thermal_system_full_B.INPUT_22_1_1[2];
  tmp_0[75] = Thermal_system_full_B.INPUT_22_1_1[3];
  tmp_1[19] = 76;
  tmp_0[76] = Thermal_system_full_B.INPUT_20_1_1[0];
  tmp_0[77] = Thermal_system_full_B.INPUT_20_1_1[1];
  tmp_0[78] = Thermal_system_full_B.INPUT_20_1_1[2];
  tmp_0[79] = Thermal_system_full_B.INPUT_20_1_1[3];
  tmp_1[20] = 80;
  tmp_0[80] = Thermal_system_full_B.INPUT_19_1_1[0];
  tmp_0[81] = Thermal_system_full_B.INPUT_19_1_1[1];
  tmp_0[82] = Thermal_system_full_B.INPUT_19_1_1[2];
  tmp_0[83] = Thermal_system_full_B.INPUT_19_1_1[3];
  tmp_1[21] = 84;
  tmp_0[84] = Thermal_system_full_B.INPUT_21_1_1[0];
  tmp_0[85] = Thermal_system_full_B.INPUT_21_1_1[1];
  tmp_0[86] = Thermal_system_full_B.INPUT_21_1_1[2];
  tmp_0[87] = Thermal_system_full_B.INPUT_21_1_1[3];
  tmp_1[22] = 88;
  tmp_0[88] = Thermal_system_full_B.INPUT_23_1_1[0];
  tmp_0[89] = Thermal_system_full_B.INPUT_23_1_1[1];
  tmp_0[90] = Thermal_system_full_B.INPUT_23_1_1[2];
  tmp_0[91] = Thermal_system_full_B.INPUT_23_1_1[3];
  tmp_1[23] = 92;
  tmp_0[92] = Thermal_system_full_B.INPUT_24_1_1[0];
  tmp_0[93] = Thermal_system_full_B.INPUT_24_1_1[1];
  tmp_0[94] = Thermal_system_full_B.INPUT_24_1_1[2];
  tmp_0[95] = Thermal_system_full_B.INPUT_24_1_1[3];
  tmp_1[24] = 96;
  simulationData->mData->mInputValues.mN = 96;
  simulationData->mData->mInputValues.mX = &tmp_0[0];
  simulationData->mData->mInputOffsets.mN = 25;
  simulationData->mData->mInputOffsets.mX = &tmp_1[0];
  simulationData->mData->mDx.mN = 626;
  simulationData->mData->mDx.mX = &_rtXdot->Thermal_system_fullThermal_Syst[0];
  simulator = (NeslSimulator *)Thermal_system_full_DW.STATE_1_Simulator;
  diagnosticManager = (NeuDiagnosticManager *)
    Thermal_system_full_DW.STATE_1_DiagMgr;
  diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
  is = ne_simulator_method(simulator, NESL_SIM_DERIVATIVES, simulationData,
    diagnosticManager);
  if (is != 0) {
    tmp = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
    if (tmp) {
      msg = rtw_diagnostics_msg(diagnosticTree);
      rtmSetErrorStatus(Thermal_system_full_M, msg);
    }
  }

  /* End of Derivatives for SimscapeExecutionBlock: '<S354>/STATE_1' */

  /* Derivatives for Integrator: '<S40>/Integrator' */
  _rtXdot->Integrator_CSTATE = Thermal_system_full_B.Gain_c;

  /* Derivatives for Integrator: '<S41>/Integrator' */
  _rtXdot->Integrator_CSTATE_h = Thermal_system_full_B.EPower_battery;

  /* Derivatives for Integrator: '<S41>/Integrator1' */
  _rtXdot->Integrator1_CSTATE = Thermal_system_full_B.EPower_BTM;

  /* Derivatives for Integrator: '<S43>/Integrator2' incorporates:
   *  Constant: '<S43>/Constant'
   */
  _rtXdot->Integrator2_CSTATE = Thermal_system_full_P.Constant_Value_m;

  /* Derivatives for Integrator: '<S43>/Integrator' */
  _rtXdot->Integrator_CSTATE_d = Thermal_system_full_B.EPower_Compressor;

  /* Derivatives for TransferFcn: '<S53>/Transfer Fcn' */
  _rtXdot->TransferFcn_CSTATE_b = 0.0;
  _rtXdot->TransferFcn_CSTATE_b += Thermal_system_full_P.TransferFcn_A_gs *
    Thermal_system_full_X.TransferFcn_CSTATE_b;
  _rtXdot->TransferFcn_CSTATE_b += Thermal_system_full_B.cmd_heater;
}

/* Model initialize function */
void Thermal_system_full_initialize(void)
{
  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  /* non-finite (run-time) assignments */
  Thermal_system_full_P.Saturation_UpperSat = rtInf;
  Thermal_system_full_P.Saturation1_UpperSat = rtInf;

  /* initialize real-time model */
  (void) memset((void *)Thermal_system_full_M, 0,
                sizeof(RT_MODEL_Thermal_system_full_T));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Thermal_system_full_M->solverInfo,
                          &Thermal_system_full_M->Timing.simTimeStep);
    rtsiSetTPtr(&Thermal_system_full_M->solverInfo, &rtmGetTPtr
                (Thermal_system_full_M));
    rtsiSetStepSizePtr(&Thermal_system_full_M->solverInfo,
                       &Thermal_system_full_M->Timing.stepSize0);
    rtsiSetdXPtr(&Thermal_system_full_M->solverInfo,
                 &Thermal_system_full_M->derivs);
    rtsiSetContStatesPtr(&Thermal_system_full_M->solverInfo, (real_T **)
                         &Thermal_system_full_M->contStates);
    rtsiSetNumContStatesPtr(&Thermal_system_full_M->solverInfo,
      &Thermal_system_full_M->Sizes.numContStates);
    rtsiSetNumPeriodicContStatesPtr(&Thermal_system_full_M->solverInfo,
      &Thermal_system_full_M->Sizes.numPeriodicContStates);
    rtsiSetPeriodicContStateIndicesPtr(&Thermal_system_full_M->solverInfo,
      &Thermal_system_full_M->periodicContStateIndices);
    rtsiSetPeriodicContStateRangesPtr(&Thermal_system_full_M->solverInfo,
      &Thermal_system_full_M->periodicContStateRanges);
    rtsiSetErrorStatusPtr(&Thermal_system_full_M->solverInfo,
                          (&rtmGetErrorStatus(Thermal_system_full_M)));
    rtsiSetSolverMassMatrixIr(&Thermal_system_full_M->solverInfo,
      Thermal_system_full_MassMatrix.ir);
    rtsiSetSolverMassMatrixJc(&Thermal_system_full_M->solverInfo,
      Thermal_system_full_MassMatrix.jc);
    rtsiSetSolverMassMatrixPr(&Thermal_system_full_M->solverInfo,
      Thermal_system_full_MassMatrix.pr);
    rtsiSetRTModelPtr(&Thermal_system_full_M->solverInfo, Thermal_system_full_M);
  }

  rtsiSetSimTimeStep(&Thermal_system_full_M->solverInfo, MAJOR_TIME_STEP);
  Thermal_system_full_M->intgData.x0 = Thermal_system_full_M->odeX0;
  Thermal_system_full_M->intgData.f0 = Thermal_system_full_M->odeF0;
  Thermal_system_full_M->intgData.f1 = Thermal_system_full_M->odeF1;
  Thermal_system_full_M->intgData.Delta = Thermal_system_full_M->odeDELTA;
  Thermal_system_full_M->intgData.fac = Thermal_system_full_M->odeFAC;

  /* initialize */
  {
    int_T i;
    real_T *f = Thermal_system_full_M->intgData.fac;
    for (i = 0; i < (int_T)(sizeof(Thermal_system_full_M->odeFAC)/sizeof(real_T));
         i++) {
      f[i] = 1.5e-8;
    }
  }

  Thermal_system_full_M->intgData.DFDX = Thermal_system_full_M->odeDFDX;
  Thermal_system_full_M->intgData.W = Thermal_system_full_M->odeW;
  Thermal_system_full_M->intgData.pivots = Thermal_system_full_M->odePIVOTS;
  Thermal_system_full_M->intgData.z = Thermal_system_full_M->odeZ;
  Thermal_system_full_M->intgData.M = Thermal_system_full_M->odeMASSMATRIX_M;
  Thermal_system_full_M->intgData.isFirstStep = true;
  rtsiSetSolverNumberNewtonIterations(&Thermal_system_full_M->solverInfo, 1);
  Thermal_system_full_M->contStates = ((X_Thermal_system_full_T *)
    &Thermal_system_full_X);
  Thermal_system_full_M->massMatrixType = ((ssMatrixType)3);
  Thermal_system_full_M->massMatrixNzMax = (149);
  Thermal_system_full_M->massMatrixIr = (Thermal_system_full_MassMatrix.ir);
  Thermal_system_full_M->massMatrixJc = (Thermal_system_full_MassMatrix.jc);
  Thermal_system_full_M->massMatrixPr = (Thermal_system_full_MassMatrix.pr);
  rtsiSetSolverMassMatrixType(&Thermal_system_full_M->solverInfo, (ssMatrixType)
    3);
  rtsiSetSolverMassMatrixNzMax(&Thermal_system_full_M->solverInfo, 149);
  rtsiSetSolverData(&Thermal_system_full_M->solverInfo, (void *)
                    &Thermal_system_full_M->intgData);
  rtsiSetSolverName(&Thermal_system_full_M->solverInfo,"ode1be");
  rtmSetTPtr(Thermal_system_full_M, &Thermal_system_full_M->Timing.tArray[0]);
  Thermal_system_full_M->Timing.stepSize0 = 0.2;

  /* block I/O */
  (void) memset(((void *) &Thermal_system_full_B), 0,
                sizeof(B_Thermal_system_full_T));

  /* states (continuous) */
  {
    (void) memset((void *)&Thermal_system_full_X, 0,
                  sizeof(X_Thermal_system_full_T));
  }

  /* global mass matrix */
  {
    int_T *ir = Thermal_system_full_MassMatrix.ir;
    int_T *jc = Thermal_system_full_MassMatrix.jc;
    real_T *pr = Thermal_system_full_MassMatrix.pr;
    (void) memset((void *)ir, 0,
                  149*sizeof(int_T));
    (void) memset((void *)jc, 0,
                  (641+1)*sizeof(int_T));
    (void) memset((void *)pr, 0,
                  149*sizeof(real_T));
  }

  /* states (dwork) */
  (void) memset((void *)&Thermal_system_full_DW, 0,
                sizeof(DW_Thermal_system_full_T));

  /* Root-level init GlobalMassMatrixPr offset */
  {
    Thermal_system_full_DW.STATE_1_MASS_MATRIX_PR = 9;/* '<S354>/STATE_1' */
  }

  {
    /* user code (registration function declaration) */
    /*Initialize global TRC pointers. */
    Thermal_system_full_rti_init_trc_pointers();
  }

  {
    NeModelParameters modelParameters;
    NeModelParameters modelParameters_0;
    NeslRtpManager *manager;
    NeslSimulationData *tmp_0;
    NeslSimulator *simulator;
    NeuDiagnosticManager *diagnosticManager;
    NeuDiagnosticTree *diagnosticTree;
    char *msg;
    real_T tmp_1;
    int32_T tmp_2;
    boolean_T tmp;

    /* Start for S-Function (dsmpb_datainport): '<S7>/Data Inport S-Fcn' */
    Thermal_system_full_B.I_tractionValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S33>/Data Inport S-Fcn' */
    Thermal_system_full_B.v_vehicleValue = 0;

    /* Start for SimscapeRtp: '<S60>/RTP_1' */
    manager = nesl_lease_rtp_manager(
      "Thermal_system_full/Thermal System/Solver Configuration_1", 0);
    tmp = pointer_is_null(manager);
    if (tmp) {
      Thermal_system_full_b8a6bb9a_1_gateway();
      manager = nesl_lease_rtp_manager(
        "Thermal_system_full/Thermal System/Solver Configuration_1", 0);
    }

    Thermal_system_full_DW.RTP_1_RtpManager = (void *)manager;
    Thermal_system_full_DW.RTP_1_SetParametersNeeded = true;

    /* End of Start for SimscapeRtp: '<S60>/RTP_1' */

    /* Start for SimscapeExecutionBlock: '<S354>/STATE_1' */
    simulator = nesl_lease_simulator(
      "Thermal_system_full/Thermal System/Solver Configuration_1", 0, 0);
    Thermal_system_full_DW.STATE_1_Simulator = (void *)simulator;
    tmp = pointer_is_null(Thermal_system_full_DW.STATE_1_Simulator);
    if (tmp) {
      Thermal_system_full_b8a6bb9a_1_gateway();
      simulator = nesl_lease_simulator(
        "Thermal_system_full/Thermal System/Solver Configuration_1", 0, 0);
      Thermal_system_full_DW.STATE_1_Simulator = (void *)simulator;
    }

    tmp_0 = nesl_create_simulation_data();
    Thermal_system_full_DW.STATE_1_SimData = (void *)tmp_0;
    diagnosticManager = rtw_create_diagnostics();
    Thermal_system_full_DW.STATE_1_DiagMgr = (void *)diagnosticManager;
    modelParameters.mSolverType = NE_SOLVER_TYPE_DAE;
    modelParameters.mSolverTolerance = 0.001;
    modelParameters.mVariableStepSolver = false;
    modelParameters.mIsUsingODEN = false;
    modelParameters.mFixedStepSize = 0.2;
    modelParameters.mStartTime = 0.0;
    modelParameters.mLoadInitialState = false;
    modelParameters.mUseSimState = false;
    modelParameters.mLinTrimCompile = false;
    modelParameters.mLoggingMode = SSC_LOGGING_NONE;
    modelParameters.mRTWModifiedTimeStamp = 6.62036527E+8;
    tmp_1 = 0.001;
    modelParameters.mSolverTolerance = tmp_1;
    tmp_1 = 0.2;
    modelParameters.mFixedStepSize = tmp_1;
    tmp = false;
    modelParameters.mVariableStepSolver = tmp;
    tmp = false;
    modelParameters.mIsUsingODEN = tmp;
    modelParameters.mLoadInitialState = false;
    simulator = (NeslSimulator *)Thermal_system_full_DW.STATE_1_Simulator;
    diagnosticManager = (NeuDiagnosticManager *)
      Thermal_system_full_DW.STATE_1_DiagMgr;
    diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
    tmp_2 = nesl_initialize_simulator(simulator, &modelParameters,
      diagnosticManager);
    if (tmp_2 != 0) {
      tmp = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
      if (tmp) {
        msg = rtw_diagnostics_msg(diagnosticTree);
        rtmSetErrorStatus(Thermal_system_full_M, msg);
      }
    }

    /* End of Start for SimscapeExecutionBlock: '<S354>/STATE_1' */

    /* Start for SimscapeExecutionBlock: '<S354>/OUTPUT_1_0' */
    simulator = nesl_lease_simulator(
      "Thermal_system_full/Thermal System/Solver Configuration_1", 1, 0);
    Thermal_system_full_DW.OUTPUT_1_0_Simulator = (void *)simulator;
    tmp = pointer_is_null(Thermal_system_full_DW.OUTPUT_1_0_Simulator);
    if (tmp) {
      Thermal_system_full_b8a6bb9a_1_gateway();
      simulator = nesl_lease_simulator(
        "Thermal_system_full/Thermal System/Solver Configuration_1", 1, 0);
      Thermal_system_full_DW.OUTPUT_1_0_Simulator = (void *)simulator;
    }

    tmp_0 = nesl_create_simulation_data();
    Thermal_system_full_DW.OUTPUT_1_0_SimData = (void *)tmp_0;
    diagnosticManager = rtw_create_diagnostics();
    Thermal_system_full_DW.OUTPUT_1_0_DiagMgr = (void *)diagnosticManager;
    modelParameters_0.mSolverType = NE_SOLVER_TYPE_DAE;
    modelParameters_0.mSolverTolerance = 0.001;
    modelParameters_0.mVariableStepSolver = false;
    modelParameters_0.mIsUsingODEN = false;
    modelParameters_0.mFixedStepSize = 0.2;
    modelParameters_0.mStartTime = 0.0;
    modelParameters_0.mLoadInitialState = false;
    modelParameters_0.mUseSimState = false;
    modelParameters_0.mLinTrimCompile = false;
    modelParameters_0.mLoggingMode = SSC_LOGGING_NONE;
    modelParameters_0.mRTWModifiedTimeStamp = 6.62036527E+8;
    tmp_1 = 0.001;
    modelParameters_0.mSolverTolerance = tmp_1;
    tmp_1 = 0.2;
    modelParameters_0.mFixedStepSize = tmp_1;
    tmp = false;
    modelParameters_0.mVariableStepSolver = tmp;
    tmp = false;
    modelParameters_0.mIsUsingODEN = tmp;
    modelParameters_0.mLoadInitialState = false;
    simulator = (NeslSimulator *)Thermal_system_full_DW.OUTPUT_1_0_Simulator;
    diagnosticManager = (NeuDiagnosticManager *)
      Thermal_system_full_DW.OUTPUT_1_0_DiagMgr;
    diagnosticTree = neu_diagnostic_manager_get_initial_tree(diagnosticManager);
    tmp_2 = nesl_initialize_simulator(simulator, &modelParameters_0,
      diagnosticManager);
    if (tmp_2 != 0) {
      tmp = error_buffer_is_empty(rtmGetErrorStatus(Thermal_system_full_M));
      if (tmp) {
        msg = rtw_diagnostics_msg(diagnosticTree);
        rtmSetErrorStatus(Thermal_system_full_M, msg);
      }
    }

    /* End of Start for SimscapeExecutionBlock: '<S354>/OUTPUT_1_0' */

    /* Start for S-Function (dsmpb_datainport): '<S24>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_comp = 0;

    /* Start for S-Function (dsmpb_datainport): '<S25>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_fanValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S26>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_heater = 0;

    /* Start for S-Function (dsmpb_datainport): '<S29>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_rad_bypassValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S23>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_chiller_bypassValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S22>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_battery_pumpValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S27>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_motor_pumpValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S28>/Data Inport S-Fcn' */
    Thermal_system_full_B.cmd_parallel_serialValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S11>/Data Inport S-Fcn' */
    Thermal_system_full_B.Q_inverterValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S12>/Data Inport S-Fcn' */
    Thermal_system_full_B.Q_motorValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S9>/Data Inport S-Fcn' */
    Thermal_system_full_B.Q_chargerValue = 0;

    /* Start for S-Function (dsmpb_datainport): '<S10>/Data Inport S-Fcn' */
    Thermal_system_full_B.Q_dcdcValue = 0;
  }

  {
    char *tmp_0;
    int_T is;
    boolean_T tmp;

    /* InitializeConditions for TransferFcn: '<S50>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S50>/Transfer Fcn1' */
    Thermal_system_full_X.TransferFcn1_CSTATE = 0.0;

    /* InitializeConditions for TransferFcn: '<S44>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_a = 0.0;

    /* InitializeConditions for TransferFcn: '<S45>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_n = 0.0;

    /* InitializeConditions for TransferFcn: '<S48>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_k = 0.0;

    /* InitializeConditions for TransferFcn: '<S51>/Transfer Fcn1' */
    Thermal_system_full_X.TransferFcn1_CSTATE_d = 0.0;

    /* InitializeConditions for TransferFcn: '<S56>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_nn = 0.0;

    /* InitializeConditions for TransferFcn: '<S57>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_kv = 0.0;

    /* InitializeConditions for TransferFcn: '<S59>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_e = 0.0;

    /* InitializeConditions for SimscapeExecutionBlock: '<S354>/STATE_1' */
    tmp = false;
    if (tmp) {
      is = strcmp("ode1be", rtsiGetSolverName(&Thermal_system_full_M->solverInfo));
      if (is != 0) {
        tmp_0 = solver_mismatch_message("ode1be", rtsiGetSolverName
          (&Thermal_system_full_M->solverInfo));
        rtmSetErrorStatus(Thermal_system_full_M, tmp_0);
      }
    }

    /* End of InitializeConditions for SimscapeExecutionBlock: '<S354>/STATE_1' */

    /* InitializeConditions for Integrator: '<S40>/Integrator' */
    Thermal_system_full_X.Integrator_CSTATE =
      Thermal_system_full_P.Integrator_IC;

    /* InitializeConditions for Integrator: '<S41>/Integrator' */
    Thermal_system_full_X.Integrator_CSTATE_h =
      Thermal_system_full_P.Integrator_IC_i;

    /* InitializeConditions for Integrator: '<S41>/Integrator1' */
    Thermal_system_full_X.Integrator1_CSTATE =
      Thermal_system_full_P.Integrator1_IC;

    /* InitializeConditions for Integrator: '<S43>/Integrator2' */
    Thermal_system_full_X.Integrator2_CSTATE =
      Thermal_system_full_P.Integrator2_IC;

    /* InitializeConditions for Integrator: '<S43>/Integrator' */
    Thermal_system_full_X.Integrator_CSTATE_d =
      Thermal_system_full_P.Integrator_IC_f;

    /* InitializeConditions for TransferFcn: '<S53>/Transfer Fcn' */
    Thermal_system_full_X.TransferFcn_CSTATE_b = 0.0;

    /* Root-level InitSystemMatrices */
    {
      static int_T modelMassMatrixIr[149] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
        9, 10, 11, 12, 11, 12, 13, 14, 13, 14, 15, 16, 15, 16, 19, 17, 18, 20,
        22, 21, 23, 25, 24, 26, 28, 27, 29, 30, 31, 30, 31, 32, 34, 32, 33, 34,
        32, 33, 36, 38, 37, 43, 39, 42, 40, 41, 35, 62, 44, 48, 44, 45, 52, 44,
        49, 44, 50, 54, 53, 59, 55, 58, 56, 57, 44, 44, 46, 44, 47, 51, 63, 64,
        60, 61, 67, 65, 66, 65, 66, 68, 69, 70, 69, 70, 73, 71, 72, 71, 72, 76,
        74, 75, 74, 75, 77, 79, 77, 79, 80, 78, 77, 79, 80, 81, 83, 81, 83, 84,
        82, 81, 83, 84, 88, 92, 88, 89, 88, 93, 88, 94, 85, 87, 85, 86, 87, 85,
        86, 88, 88, 90, 88, 91, 635, 636, 637, 638, 639, 640 };

      static int_T modelMassMatrixJc[642] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11,
        13, 15, 17, 19, 21, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 40, 42, 44, 47, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 61,
        63, 64, 66, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 80, 81, 82, 83, 84,
        85, 86, 88, 90, 91, 93, 95, 96, 98, 100, 101, 103, 105, 107, 110, 111,
        114, 116, 119, 120, 123, 125, 127, 129, 131, 133, 136, 138, 139, 141,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143, 143,
        143, 143, 143, 143, 143, 143, 143, 143, 143, 144, 145, 146, 147, 148,
        149 };

      static real_T modelMassMatrixPr[149] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
        1.0, 1.0 };

      (void) memcpy(Thermal_system_full_MassMatrix.ir, modelMassMatrixIr,
                    149*sizeof(int_T));
      (void) memcpy(Thermal_system_full_MassMatrix.jc, modelMassMatrixJc,
                    642*sizeof(int_T));
      (void) memcpy(Thermal_system_full_MassMatrix.pr, modelMassMatrixPr,
                    149*sizeof(real_T));
    }
  }
}

/* Model terminate function */
void Thermal_system_full_terminate(void)
{
  NeslSimulationData *simulationData;
  NeuDiagnosticManager *diagnosticManager;

  /* Terminate for SimscapeExecutionBlock: '<S354>/STATE_1' */
  diagnosticManager = (NeuDiagnosticManager *)
    Thermal_system_full_DW.STATE_1_DiagMgr;
  neu_destroy_diagnostic_manager(diagnosticManager);
  simulationData = (NeslSimulationData *)Thermal_system_full_DW.STATE_1_SimData;
  nesl_destroy_simulation_data(simulationData);
  nesl_erase_simulator("Thermal_system_full/Thermal System/Solver Configuration_1");
  nesl_destroy_registry();

  /* Terminate for SimscapeExecutionBlock: '<S354>/OUTPUT_1_0' */
  diagnosticManager = (NeuDiagnosticManager *)
    Thermal_system_full_DW.OUTPUT_1_0_DiagMgr;
  neu_destroy_diagnostic_manager(diagnosticManager);
  simulationData = (NeslSimulationData *)
    Thermal_system_full_DW.OUTPUT_1_0_SimData;
  nesl_destroy_simulation_data(simulationData);
  nesl_erase_simulator("Thermal_system_full/Thermal System/Solver Configuration_1");
  nesl_destroy_registry();
}
